/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.junit;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.testing.Injector;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InjectRule
implements TestRule {
    private final Object instance;

    public InjectRule(Object instance) {
        this.instance = instance;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                CreationalContext<?> creationalContext = null;
                try {
                    creationalContext = Injector.inject(InjectRule.this.instance);
                    Injector.injectConfig((Meecrowave.Builder)CDI.current().select(Meecrowave.Builder.class, new Annotation[0]).get(), InjectRule.this.instance);
                    base.evaluate();
                }
                finally {
                    if (creationalContext != null) {
                        creationalContext.release();
                    }
                }
            }
        };
    }
}

