/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.junit5;

import jakarta.enterprise.context.spi.CreationalContext;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.junit5.BaseLifecycle;
import org.apache.meecrowave.junit5.MeecrowaveConfig;
import org.apache.meecrowave.junit5.ScopesExtension;
import org.apache.meecrowave.testing.Injector;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class MeecrowaveExtension
extends BaseLifecycle
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MeecrowaveExtension.class.getName()});
    private final ScopesExtension scopes = new ScopesExtension(){

        @Override
        protected Optional<Class<? extends Annotation>[]> getScopes(ExtensionContext context) {
            return context.getElement().map(e -> MeecrowaveExtension.this.findConfig(context)).map(MeecrowaveConfig::scopes).filter(s -> ((Class[])s).length > 0);
        }
    };

    public void beforeAll(ExtensionContext context) {
        if (this.isPerClass(context)) {
            this.doStart(context);
        }
    }

    public void afterAll(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        Optional.ofNullable(store.get(BaseLifecycle.LifecyleState.class, BaseLifecycle.LifecyleState.class)).ifPresent(s -> s.afterLastTest(context));
        if (this.isPerClass(context)) {
            ((Meecrowave)store.get(Meecrowave.class, Meecrowave.class)).close();
        }
    }

    public void beforeEach(ExtensionContext context) {
        if (!this.isPerClass(context)) {
            this.doStart(context);
        }
    }

    public void afterEach(ExtensionContext context) {
        if (!this.isPerClass(context)) {
            this.doRelease(context);
            ((Meecrowave)context.getStore(NAMESPACE).get(Meecrowave.class, Meecrowave.class)).close();
        }
    }

    private void doStart(ExtensionContext context) {
        String ctx;
        Meecrowave.Builder builder = new Meecrowave.Builder();
        MeecrowaveConfig config = this.findConfig(context);
        if (config != null) {
            ctx = config.context();
            for (Method method : MeecrowaveConfig.class.getMethods()) {
                if (MeecrowaveConfig.class != method.getDeclaringClass()) continue;
                try {
                    Object value = method.invoke((Object)config, new Object[0]);
                    Field configField = Configuration.class.getDeclaredField(method.getName());
                    if (!configField.isAccessible()) {
                        configField.setAccessible(true);
                    }
                    if (value == null || String.class.isInstance(value) && value.toString().isEmpty()) continue;
                    if (!configField.isAccessible()) {
                        configField.setAccessible(true);
                    }
                    configField.set(builder, File.class == configField.getType() ? new File(value.toString()) : value);
                }
                catch (NoSuchFieldException value) {
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            if (builder.getHttpPort() < 0) {
                builder.randomHttpPort();
            }
        } else {
            ctx = "";
        }
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        Meecrowave meecrowave = new Meecrowave((Configuration)builder);
        store.put(Meecrowave.class, (Object)meecrowave);
        store.put(Meecrowave.Builder.class, (Object)builder);
        meecrowave.bake(ctx);
        this.doInject(context);
        store.put(BaseLifecycle.LifecyleState.class, (Object)this.onInjection(context, null));
    }

    private MeecrowaveConfig findConfig(ExtensionContext context) {
        return AnnotationUtils.findAnnotation((Optional)context.getElement(), MeecrowaveConfig.class).orElseGet(() -> context.getParent().flatMap(ExtensionContext::getElement).flatMap(it -> AnnotationUtils.findAnnotation((AnnotatedElement)it, MeecrowaveConfig.class)).orElse(null));
    }

    private void doRelease(ExtensionContext context) {
        Optional.ofNullable(context.getStore(NAMESPACE).get(CreationalContext.class, CreationalContext.class)).ifPresent(CreationalContext::release);
        this.scopes.beforeEach(context);
    }

    private void doInject(ExtensionContext context) {
        this.scopes.beforeEach(context);
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        store.put(CreationalContext.class, Injector.inject(context.getTestInstance().orElse(null)));
        Injector.injectConfig((Meecrowave.Builder)store.get(Meecrowave.Builder.class, Meecrowave.Builder.class), context.getTestInstance().orElse(null));
    }
}

