/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.junit5;

import jakarta.enterprise.context.spi.CreationalContext;
import java.util.Optional;
import org.apache.meecrowave.junit5.BaseLifecycle;
import org.apache.meecrowave.testing.Injector;
import org.apache.meecrowave.testing.MonoBase;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class MonoMeecrowaveExtension
extends BaseLifecycle
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final MonoBase BASE = new MonoBase();
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MonoMeecrowaveExtension.class.getName()});

    public void beforeAll(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        store.put(MonoBase.Instance.class, (Object)BASE.startIfNeeded());
        if (this.isPerClass(context)) {
            this.doInject(context);
            store.put(BaseLifecycle.LifecyleState.class, (Object)this.onInjection(context, null));
        }
    }

    public void beforeEach(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        if (!this.isPerClass(context)) {
            this.doInject(context);
            store.put(BaseLifecycle.LifecyleState.class, (Object)this.onInjection(context.getParent().orElse(context), (BaseLifecycle.LifecyleState)store.get(BaseLifecycle.LifecyleState.class, BaseLifecycle.LifecyleState.class)));
        }
    }

    public void afterEach(ExtensionContext context) {
        if (!this.isPerClass(context)) {
            this.doRelease(context);
        }
    }

    public void afterAll(ExtensionContext context) {
        Optional.ofNullable(context.getStore(NAMESPACE).get(BaseLifecycle.LifecyleState.class, BaseLifecycle.LifecyleState.class)).ifPresent(s -> s.afterLastTest(context));
        if (this.isPerClass(context)) {
            this.doRelease(context);
        }
    }

    private void doRelease(ExtensionContext context) {
        ((CreationalContext)context.getStore(NAMESPACE).get(CreationalContext.class, CreationalContext.class)).release();
    }

    private void doInject(ExtensionContext context) {
        context.getStore(NAMESPACE).put(CreationalContext.class, Injector.inject(context.getTestInstance().orElse(null)));
        Injector.injectConfig(((MonoBase.Instance)context.getStore(NAMESPACE).get(MonoBase.Instance.class, MonoBase.Instance.class)).getConfiguration(), context.getTestInstance().orElse(null));
    }
}

