/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.spring;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.pojo.ArrayTableDataProvider;
import org.apache.metamodel.pojo.PojoDataContext;
import org.apache.metamodel.pojo.TableDataProvider;
import org.apache.metamodel.spring.AbstractDataContextFactoryBeanDelegate;
import org.apache.metamodel.spring.DataContextFactoryParameters;
import org.apache.metamodel.util.SimpleTableDef;

public class PojoDataContextFactoryBeanDelegate
extends AbstractDataContextFactoryBeanDelegate {
    @Override
    public DataContext createDataContext(DataContextFactoryParameters params) {
        SimpleTableDef[] tableDefs = params.getTableDefs();
        if (tableDefs == null || tableDefs.length == 0) {
            throw new IllegalArgumentException("Cannot create PojoDataContext with no tableDefs specified");
        }
        ArrayTableDataProvider[] tableDataProviders = new ArrayTableDataProvider[tableDefs.length];
        for (int i = 0; i < tableDataProviders.length; ++i) {
            ArrayTableDataProvider tableDataProvider;
            tableDataProviders[i] = tableDataProvider = new ArrayTableDataProvider(tableDefs[i], new ArrayList());
        }
        String databaseName = params.getDatabaseName();
        if (databaseName != null && !databaseName.isEmpty()) {
            return new PojoDataContext(databaseName, (TableDataProvider[])tableDataProviders);
        }
        return new PojoDataContext(Arrays.asList(tableDataProviders));
    }
}

