/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.util.renderkit;

import org.apache.myfaces.commons.util.ArrayUtils;


/**
 * Constant declarations for HTML rendering.
 * @author Manfred Geiler
 * @author Anton Koinov
 * @version $Revision: 938289 $ $Date: 2010-04-26 20:35:24 -0500 (Lun, 26 Abr 2010) $
 */
public final class HTML
{

    // Common attributes
    public String ALIGN_ATTR = "align";
    public String BORDER_ATTR = "border";
    public String WIDTH_ATTR = "width";
    public String READONLY_ATTR = "readonly";
    public String FILE_ATTR = "file";
    public String ACCEPT_ATTR = "accept";

    // Common event handler attributes
    public String ONCLICK_ATTR     = "onclick";
    public String ONDBLCLICK_ATTR  = "ondblclick";
    public String ONMOUSEDOWN_ATTR = "onmousedown";
    public String ONMOUSEUP_ATTR   = "onmouseup";
    public String ONMOUSEOVER_ATTR = "onmouseover";
    public String ONMOUSEMOVE_ATTR = "onmousemove";
    public String ONMOUSEOUT_ATTR  = "onmouseout";
    public String ONKEYPRESS_ATTR  = "onkeypress";
    public String ONKEYDOWN_ATTR   = "onkeydown";
    public String ONKEYUP_ATTR     = "onkeyup";
    public String ONFOCUS_ATTR = "onfocus";
    public String ONBLUR_ATTR = "onblur";
    public String[] EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONCLICK =
    {
        ONDBLCLICK_ATTR,
        ONMOUSEDOWN_ATTR,
        ONMOUSEUP_ATTR,
        ONMOUSEOVER_ATTR,
        ONMOUSEMOVE_ATTR,
        ONMOUSEOUT_ATTR,
        ONKEYPRESS_ATTR,
        ONKEYDOWN_ATTR,
        ONKEYUP_ATTR
    };
    public String[] EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONMOUSEOVER_AND_ONMOUSEOUT =
    {
        ONDBLCLICK_ATTR,
        ONMOUSEDOWN_ATTR,
        ONMOUSEUP_ATTR,
        ONMOUSEMOVE_ATTR,
        ONKEYPRESS_ATTR,
        ONKEYDOWN_ATTR,
        ONKEYUP_ATTR,
        ONCLICK_ATTR
    };
    public String[] EVENT_HANDLER_ATTRIBUTES =
            (String[]) ArrayUtils.concat(
                EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONCLICK,
                new String[] {ONCLICK_ATTR});

    // Input field event handler attributes
    public String ONSELECT_ATTR = "onselect";
    public String ONCHANGE_ATTR = "onchange";
    public String[] COMMON_FIELD_EVENT_ATTRIBUTES =
    {
        ONFOCUS_ATTR,
        ONBLUR_ATTR,
        ONSELECT_ATTR,
        ONCHANGE_ATTR
    };

    public String[] COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONFOCUS =
    {
        ONBLUR_ATTR,
        ONSELECT_ATTR,
        ONCHANGE_ATTR
    };
    
    public String[] COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONSELECT_AND_ONCHANGE =
    {
        ONFOCUS_ATTR,
        ONBLUR_ATTR
    };

    // universal attributes
    public String DIR_ATTR   = "dir";
    public String LANG_ATTR  = "lang";
    public String STYLE_ATTR = "style";
    public String TITLE_ATTR = "title";
    public String STYLE_CLASS_ATTR = "styleClass"; //"class" cannot be used as property name
     
    public String[] UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE =
    {
        DIR_ATTR,
        LANG_ATTR,
        TITLE_ATTR,

        //NOTE: if changed, please verify universal attributes in HtmlMessageRenderer !
    };
    public String[] UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE_AND_TITLE =
    {
        DIR_ATTR,
        LANG_ATTR,
    };
    public String[] UNIVERSAL_ATTRIBUTES =
            (String[]) ArrayUtils.concat(
                UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE,
                new String[] {STYLE_ATTR, STYLE_CLASS_ATTR});

    //universal, but not the same property-name -
    //styleClass attribute is rendered as such
    public String CLASS_ATTR = "class";

    // common form field attributes
    public String ACCESSKEY_ATTR   = "accesskey";
    public String TABINDEX_ATTR    = "tabindex";
    public String DISABLED_ATTR = "disabled";
    public String[] COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED =
    {
        ACCESSKEY_ATTR,
        TABINDEX_ATTR
    };
    public String[] COMMON_FIELD_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
            COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED,
            new String[] {DISABLED_ATTR});

    // Common Attributes
    public String[] COMMON_PASSTROUGH_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
            EVENT_HANDLER_ATTRIBUTES,
            UNIVERSAL_ATTRIBUTES);
    public String[] COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_STYLE =
        (String[]) ArrayUtils.concat(
            EVENT_HANDLER_ATTRIBUTES,
            UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE);
    public String[] COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_ONCLICK =
        (String[]) ArrayUtils.concat(
            EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONCLICK,
            UNIVERSAL_ATTRIBUTES);
    public String[] COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_ONCLICK_WITHOUT_STYLE =
        (String[]) ArrayUtils.concat(
            EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONCLICK,
            UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE);
    public String[] COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED =
        (String[]) ArrayUtils.concat(
            COMMON_PASSTROUGH_ATTRIBUTES,
            COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED,
            COMMON_FIELD_EVENT_ATTRIBUTES);
    public String[] COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE =
        (String[]) ArrayUtils.concat(
            COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_STYLE,
            COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED,
            COMMON_FIELD_EVENT_ATTRIBUTES);
    public String[] COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONFOCUS =
        (String[]) ArrayUtils.concat(
            COMMON_PASSTROUGH_ATTRIBUTES,
            COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED,
            COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONFOCUS);
    public String[] COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONFOCUS_AND_ONCLICK =
        (String[]) ArrayUtils.concat(
            COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_ONCLICK,
            COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED,
            COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONFOCUS);
    public String[] COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONCLICK =
        (String[]) ArrayUtils.concat(
            COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_ONCLICK,
            COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED,
            COMMON_FIELD_EVENT_ATTRIBUTES);
    public String[] COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_ONMOUSEOVER_AND_ONMOUSEOUT =
        (String[]) ArrayUtils.concat(
            EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONMOUSEOVER_AND_ONMOUSEOUT,
            UNIVERSAL_ATTRIBUTES);
    public String[] COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS =
        (String[]) ArrayUtils.concat(
            UNIVERSAL_ATTRIBUTES,
            COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED);
    public String[] COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE_AND_EVENTS =
        (String[]) ArrayUtils.concat(
            UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE,
            COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED);
    
    // <a>
    public String TARGET_ATTR = "target";  //used by <a> and <form>
    public String CHARSET_ATTR     = "charset";
    public String COORDS_ATTR      = "coords";
    public String HREF_ATTR    = "href";
    public String HREFLANG_ATTR    = "hreflang";
    public String REL_ATTR         = "rel";
    public String REV_ATTR         = "rev";
    public String SHAPE_ATTR       = "shape";
    public String TYPE_ATTR        = "type";
    public String[] ANCHOR_ATTRIBUTES =
    {
        ACCESSKEY_ATTR,
        CHARSET_ATTR,
        COORDS_ATTR,
        HREFLANG_ATTR,
        REL_ATTR,
        REV_ATTR,
        SHAPE_ATTR,
        TABINDEX_ATTR,
        TARGET_ATTR,
        TYPE_ATTR
    };
    public String[] ANCHOR_PASSTHROUGH_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
            ANCHOR_ATTRIBUTES,
            COMMON_PASSTROUGH_ATTRIBUTES,
            COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONSELECT_AND_ONCHANGE);
    public String[] ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_STYLE =
        (String[]) ArrayUtils.concat(
            ANCHOR_ATTRIBUTES,
            COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_STYLE,
            COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONSELECT_AND_ONCHANGE);
    public String[] ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_ONCLICK_WITHOUT_STYLE =
        (String[]) ArrayUtils.concat(
            ANCHOR_ATTRIBUTES,
            COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_ONCLICK_WITHOUT_STYLE,
            COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONSELECT_AND_ONCHANGE);
    public String[] ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS =
        (String[]) ArrayUtils.concat(
            ANCHOR_ATTRIBUTES,
            UNIVERSAL_ATTRIBUTES);
    public String[] ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_STYLE_AND_EVENTS =
        (String[]) ArrayUtils.concat(
            ANCHOR_ATTRIBUTES,
            UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE);

    // <form>
    public String ACCEPT_CHARSET_ATTR = "accept-charset";
    public String ENCTYPE_ATTR = "enctype";
    public String ONRESET_ATTR = "onreset";
    public String ONSUMBIT_ATTR = "onsubmit";
    public String[] FORM_ATTRIBUTES =
    {
        ACCEPT_ATTR,
        ACCEPT_CHARSET_ATTR,
        ENCTYPE_ATTR,
        ONRESET_ATTR,
        ONSUMBIT_ATTR,
        TARGET_ATTR,
    };
    public String[] FORM_PASSTHROUGH_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
            FORM_ATTRIBUTES,
            COMMON_PASSTROUGH_ATTRIBUTES);
    public String[] FORM_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS =
        (String[]) ArrayUtils.concat(
            FORM_ATTRIBUTES,
            UNIVERSAL_ATTRIBUTES);
    // <img>
    public String SRC_ATTR = "src";
    public String ALT_ATTR = "alt";
    public String HEIGHT_ATTR = "height";
    public String HSPACE_ATTR = "hspace";
    public String ISMAP_ATTR = "ismap";
    public String LONGDESC_ATTR = "longdesc";
    public String USEMAP_ATTR = "usemap";
    public String VSPACE_ATTR = "vspace";

    public String[] IMG_ATTRIBUTES =
    {
        ALIGN_ATTR,
        ALT_ATTR,
        BORDER_ATTR,
        HEIGHT_ATTR,
        HSPACE_ATTR,
        ISMAP_ATTR,
        LONGDESC_ATTR,
        USEMAP_ATTR,
        VSPACE_ATTR,
        WIDTH_ATTR
    };
    public String[] IMG_PASSTHROUGH_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
           IMG_ATTRIBUTES,
           COMMON_PASSTROUGH_ATTRIBUTES);
    public String[] IMG_PASSTHROUGH_ATTRIBUTES_WITHOUT_ONMOUSEOVER_AND_ONMOUSEOUT =
        (String[]) ArrayUtils.concat(
           IMG_ATTRIBUTES,
           COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_ONMOUSEOVER_AND_ONMOUSEOUT);
    public String[] IMG_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS =
        (String[]) ArrayUtils.concat(
           IMG_ATTRIBUTES,
           UNIVERSAL_ATTRIBUTES);
    // <input>
    public String SIZE_ATTR = "size";
    public String AUTOCOMPLETE_ATTR = "autocomplete";
    public String CHECKED_ATTR = "checked";
    public String MAXLENGTH_ATTR = "maxlength";

    public String[] INPUT_ATTRIBUTES = {
        ALIGN_ATTR,
        ALT_ATTR,
        CHECKED_ATTR,
        MAXLENGTH_ATTR,
        READONLY_ATTR,
        SIZE_ATTR
    };
    public String[] INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED =
        (String[]) ArrayUtils.concat(
                INPUT_ATTRIBUTES,
                COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED);
    public String[] INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE =
        (String[]) ArrayUtils.concat(
                INPUT_ATTRIBUTES,
                COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE);

    public String[] INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONFOCUS_AND_ONCLICK =
        (String[]) ArrayUtils.concat(
                INPUT_ATTRIBUTES,
                COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONFOCUS_AND_ONCLICK);

    public String[] INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS =
        (String[]) ArrayUtils.concat(
                INPUT_ATTRIBUTES,
                COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
    
    public String[] INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE_AND_EVENTS =
        (String[]) ArrayUtils.concat(
                INPUT_ATTRIBUTES,
                COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE_AND_EVENTS);

    //values for input-type attribute
    public String INPUT_TYPE_SUBMIT = "submit";
    public String INPUT_TYPE_IMAGE = "image";
    public String INPUT_TYPE_HIDDEN = "hidden";
    public String INPUT_TYPE_CHECKBOX = "checkbox";
    public String INPUT_TYPE_PASSWORD = "password";
    public String INPUT_TYPE_TEXT = "text";
    public String INPUT_TYPE_RADIO = "radio";
    public String INPUT_TYPE_BUTTON = "button";

    // <button>
    public String[] BUTTON_ATTRIBUTES =
    {
        ALIGN_ATTR,
        ALT_ATTR,
    };
    public String[] BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED =
        (String[]) ArrayUtils.concat(
            BUTTON_ATTRIBUTES,
            COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED);
    public String[] BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONCLICK =
        (String[]) ArrayUtils.concat(
            BUTTON_ATTRIBUTES,
            COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONCLICK);
    public String[] BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS =
        (String[]) ArrayUtils.concat(
            BUTTON_ATTRIBUTES,
            COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);

    // <iframe>
    public String FRAMEBORDER_ATTR = "frameborder";
    public String SCROLLING_ATTR = "scrolling";

    // <label>
    public String FOR_ATTR = "for";
    public String[] LABEL_ATTRIBUTES =
    {
        ACCESSKEY_ATTR,
        ONBLUR_ATTR,
        ONFOCUS_ATTR
        //FOR_ATTR is no pass through !
    };
    public String[] LABEL_ATTRIBUTES_WITHOUT_EVENTS =
    {
        ACCESSKEY_ATTR
    };
    public String[] LABEL_PASSTHROUGH_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
            LABEL_ATTRIBUTES,
            COMMON_PASSTROUGH_ATTRIBUTES);
    public String[] LABEL_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS =
        (String[]) ArrayUtils.concat(
            LABEL_ATTRIBUTES_WITHOUT_EVENTS,
            UNIVERSAL_ATTRIBUTES);

    // <select>
    public String MULTIPLE_ATTR = "multiple";

    public String[] SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED = 
            COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED;
    public String[] SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS = 
        COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS;

    // <table>
    public String BGCOLOR_ATTR = "bgcolor";
    public String CELLPADDING_ATTR = "cellpadding";
    public String CELLSPACING_ATTR = "cellspacing";
    public String FRAME_ATTR = "frame";
    public String RULES_ATTR = "rules";
    public String SUMMARY_ATTR = "summary";
    public String[] TABLE_ATTRIBUTES = {
        ALIGN_ATTR,
        BGCOLOR_ATTR,
        BORDER_ATTR,
        CELLPADDING_ATTR,
        CELLSPACING_ATTR,
        FRAME_ATTR,
        RULES_ATTR,
        SUMMARY_ATTR,
        WIDTH_ATTR
    };
    public String[] TABLE_PASSTHROUGH_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
            TABLE_ATTRIBUTES,
            COMMON_PASSTROUGH_ATTRIBUTES);
    public String[] TABLE_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS =
        (String[]) ArrayUtils.concat(
            TABLE_ATTRIBUTES,
            UNIVERSAL_ATTRIBUTES);

    // <textarea>
    public String COLS_ATTR = "cols";
    public String ROWS_ATTR = "rows";
    public String WRAP_ATTR = "wrap";
    public String[] TEXTAREA_ATTRIBUTES =
    {
        COLS_ATTR,
        READONLY_ATTR,
        ROWS_ATTR,
        WRAP_ATTR
    };
    public String[] TEXTAREA_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED =
        (String[]) ArrayUtils.concat(
            TEXTAREA_ATTRIBUTES,
            COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED);
    public String[] TEXTAREA_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS =
        (String[]) ArrayUtils.concat(
            TEXTAREA_ATTRIBUTES,
            COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);

    // <input type=file>
    public String[] INPUT_FILE_UPLOAD_ATTRIBUTES =
    {
        ACCEPT_ATTR
    };
    public String[] INPUT_FILE_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED =
        (String[]) ArrayUtils.concat(
            INPUT_FILE_UPLOAD_ATTRIBUTES,
            INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
    public String[] INPUT_FILE_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS =
        (String[]) ArrayUtils.concat(
            INPUT_FILE_UPLOAD_ATTRIBUTES,
            INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);

    /*
    String[] MESSAGE_PASSTHROUGH_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
            new String[] {DIR_ATTR, LANG_ATTR, TITLE_ATTR, STYLE_ATTR, STYLE_CLASS_ATTR},
            EVENT_HANDLER_ATTRIBUTES);
            */

    public String[] MESSAGE_PASSTHROUGH_ATTRIBUTES_WITHOUT_TITLE_STYLE_AND_STYLE_CLASS =
        (String[]) ArrayUtils.concat(
            new String[] {DIR_ATTR, LANG_ATTR},
            EVENT_HANDLER_ATTRIBUTES);


    // selectOne/Many table
    public String[] SELECT_TABLE_PASSTHROUGH_ATTRIBUTES =
        new String[] {STYLE_ATTR, STYLE_CLASS_ATTR, BORDER_ATTR};

    public String COMPACT_ATTR = "compact";
    public String[] UL_ATTRIBUTES = {
        COMPACT_ATTR,
        TYPE_ATTR
    };
    public String[] UL_PASSTHROUGH_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
            UL_ATTRIBUTES,
            COMMON_PASSTROUGH_ATTRIBUTES);
    public String[] UL_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS =
        (String[]) ArrayUtils.concat(
            UL_ATTRIBUTES,
            UNIVERSAL_ATTRIBUTES);

    //body
    public String BODY_ELEM = "body";
    public String BODY_TARGET = BODY_ELEM;
    
    public String ONLOAD_ATTR = "onload";
    public String ONUNLOAD_ATTR = "onunload";
    public String ALINK_ATTR = "alink";
    public String VLINK_ATTR = "vlink";
    public String LINK_ATTR = "link";
    public String TEXT_ATTR = "text";
    public String BACKGROUND_ATTR = "background";

    public String[] BODY_ATTRIBUTES =
    {
        ONLOAD_ATTR,
        ONUNLOAD_ATTR,
        ALINK_ATTR,
        VLINK_ATTR,
        LINK_ATTR,
        TEXT_ATTR,
        BACKGROUND_ATTR,
        BGCOLOR_ATTR
    };
    
    public String[] BODY_ATTRIBUTES_WITHOUT_EVENTS =
    {
        ALINK_ATTR,
        VLINK_ATTR,
        LINK_ATTR,
        TEXT_ATTR,
        BACKGROUND_ATTR,
        BGCOLOR_ATTR
    };

    public String[] BODY_PASSTHROUGH_ATTRIBUTES =
        (String[]) ArrayUtils.concat(
                COMMON_PASSTROUGH_ATTRIBUTES,
                BODY_ATTRIBUTES);
    public String[] BODY_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS =
        (String[]) ArrayUtils.concat(
                UNIVERSAL_ATTRIBUTES,
                BODY_ATTRIBUTES_WITHOUT_EVENTS);
    //HTML attributes needed for renderding only
    public String ID_ATTR = "id";
    public String NAME_ATTR = "name";
    public String VALUE_ATTR = "value";
    public String METHOD_ATTR = "method";
    public String ACTION_ATTR = "action";
    public String COLSPAN_ATTR = "colspan";
    public String SCOPE_ATTR = "scope";
    public String LABEL_ATTR = "label";
    public String SELECTED_ATTR = "selected";

    //HTML attributes values
    public String SCOPE_COLGROUP_VALUE = "colgroup";
    public String SCOPE_ROW_VALUE = "row";

    //HTML element constants
    public String SPAN_ELEM = "span";
    public String DIV_ELEM = "div";
    public String INPUT_ELEM = "input";
    public String BUTTON_ELEM = "button";
    public String SELECT_ELEM = "select";
    public String OPTION_ELEM = "option";
    public String OPTGROUP_ELEM = "optgroup";
    public String TEXTAREA_ELEM = "textarea";
    public String FORM_ELEM = "form";
    public String ANCHOR_ELEM = "a";
    public String H1_ELEM = "h1";
    public String H2_ELEM = "h2";
    public String H3_ELEM = "h3";
    public String H4_ELEM = "h4";
    public String H5_ELEM = "h5";
    public String H6_ELEM = "h6";
    public String IFRAME_ELEM = "iframe";
    public String IMG_ELEM = "img";
    public String LABEL_ELEM = "label";
    public String TABLE_ELEM = "table";
    public String CAPTION_ELEM = "caption";
    public String TR_ELEM = "tr";
    public String TH_ELEM = "th";
    public String TD_ELEM = "td";
    public String TBODY_ELEM = "tbody";
    public String TFOOT_ELEM = "tfoot";
    public String THEAD_ELEM = "thead";
    public String STYLE_ELEM = "style";
    public String SCRIPT_ELEM = "script";
    public String SCRIPT_TYPE_ATTR = "type";
    public String SCRIPT_TYPE_TEXT_JAVASCRIPT = "text/javascript";
    public String STYLE_TYPE_TEXT_CSS = "text/css";
    public String SCRIPT_LANGUAGE_ATTR = "language";
    public String SCRIPT_LANGUAGE_JAVASCRIPT = "JavaScript";
    public String SCRIPT_ELEM_DEFER_ATTR = "defer";
    public String LINK_ELEM = "link";
    public String STYLESHEET_VALUE = "stylesheet";
    public String UL_ELEM = "ul";
    public String OL_ELEM = "ol";
    public String LI_ELEM = "li";


    //HTML simple element constants
    public String BR_ELEM = "br";


    //HTML entities
    public String NBSP_ENTITY = "&#160;";

    public String HREF_PATH_SEPARATOR = "/";
    public String HREF_PATH_FROM_PARAM_SEPARATOR = "?";
    //removed because wrong for XHTML and not used anyway: String HREF_PARAM_SEPARATOR = "&";
    public String HREF_PARAM_NAME_FROM_VALUE_SEPARATOR = "=";

}
