/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.outputClientId;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

import org.apache.myfaces.buildtools.maven2.plugin.builder.annotation.JSFComponent;
import org.apache.myfaces.buildtools.maven2.plugin.builder.annotation.JSFProperty;

/**
 * Output the clientId of a component specified by for property.
 * 
 * @author Leonardo Uribe
 * @since 1.0.1
 */
@JSFComponent(
        name = "mc:outputClientId",
        clazz = "org.apache.myfaces.commons.outputClientId.OutputClientId",
        tagClass = "org.apache.myfaces.commons.outputClientId.OutputClientIdTag")
public abstract class AbstractOutputClientId extends UIComponentBase
{
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.commons.OutputClientId";

    /**
     * The ID of the component that should be rendered.
     * 
     * @return
     */
    @JSFProperty
    public abstract String getFor();

    @Override
    public void encodeBegin(FacesContext context) throws IOException
    {
        super.encodeBegin(context);

        String forId = getFor();
        UIComponent referencedComponent = null;

        if (forId == null)
        {
            referencedComponent = getParent();
        }
        else
        {
            referencedComponent = this.findComponent(forId);
        }

        if (referencedComponent == null)
        {
            throw new IllegalStateException("No component found for id : "
                    + forId);
        }

        context.getResponseWriter().write(
                referencedComponent.getClientId(context));
    }
}
