/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.myfaces.tobago.maven.plugin.AbstractThemeMojo;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

public class UnPackThemeMojo
extends AbstractThemeMojo {
    private ArchiverManager archiverManager;
    private File workDirectory;
    private File webappDirectory;
    private List pluginArtifacts;

    private boolean findThemeDescriptor(File jarFile) throws MojoExecutionException {
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(new FileInputStream(jarFile));
            while (true) {
                if (zip.available() > 0) {
                    ZipEntry nextEntry = zip.getNextEntry();
                    if (nextEntry == null || nextEntry.isDirectory()) continue;
                    String name = nextEntry.getName();
                    if (!name.equals("META-INF/tobago-theme.xml")) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error find ThemeDescriptor in " + jarFile, (Exception)e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    public void execute() throws MojoExecutionException {
        Iterator artifacts = this.getProject().getDependencyArtifacts().iterator();
        while (artifacts.hasNext()) {
            if (!this.workDirectory.exists()) {
                this.workDirectory.mkdirs();
            }
            Artifact artifact = (Artifact)artifacts.next();
            this.getLog().debug((CharSequence)("Expanding theme " + artifact));
            if (!"compile".equals(artifact.getScope()) || !"jar".equals(artifact.getType()) || !this.findThemeDescriptor(artifact.getFile())) continue;
            String name = artifact.getFile().getName();
            this.getLog().debug((CharSequence)("Expanding theme " + name));
            File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
            boolean process = false;
            if (!tempLocation.exists()) {
                tempLocation.mkdirs();
                process = true;
            } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
                process = true;
            }
            if (!process) continue;
            File file = artifact.getFile();
            try {
                String[] fileNames;
                this.unpack(file, tempLocation);
                for (String fileName : fileNames = this.getThemeFiles(tempLocation)) {
                    File fromFile = new File(tempLocation, fileName);
                    File toFile = new File(this.webappDirectory, fileName);
                    try {
                        FileUtils.copyFile((File)fromFile, (File)toFile);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error copy file: " + fromFile + "to: " + toFile, (Exception)e);
                    }
                }
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
        }
    }

    private void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase(Locale.ENGLISH);
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }
}

