/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.examples.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.examples.common.CarConfigurator;
import org.apache.myfaces.examples.util.LocalizedSelectItem;

public class CarConfigurator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static List _cars;
    private static List _colors;
    private static List _extrasList;
    private static HashMap _priceList;
    private static HashMap _priceFactorColors;
    private static HashMap _priceListExtras;
    private BigDecimal _price = new BigDecimal(0);
    private String[] _extras;
    private String _discount = "0";
    private String _discount2 = "0";
    private String _bandName;
    private String _car;
    private Color _color = new Color("color_blue");
    private List _interiorColors = null;
    private boolean _salesTax = false;
    private Long _doors = new Long(4L);

    public Long getDoors() {
        return this._doors;
    }

    public void setDoors(Long doors) {
        this._doors = doors;
    }

    public List getCars() {
        return _cars;
    }

    public List getColors() {
        return _colors;
    }

    public List getExtrasList() {
        return _extrasList;
    }

    public String getCar() {
        return this._car;
    }

    public void setCar(String car) {
        this._car = car;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public List getInteriorColors() {
        return this._interiorColors;
    }

    public void setInteriorColors(List interiorColors) {
        this._interiorColors = interiorColors;
    }

    public BigDecimal getPrice() {
        return this._price;
    }

    public void setPrice(BigDecimal price) {
        this._price = price;
    }

    public String[] getExtras() {
        return this._extras;
    }

    public void setExtras(String[] extras) {
        this._extras = extras;
    }

    public String getDiscount() {
        return this._discount;
    }

    public void setDiscount(String discount) {
        this._discount = discount;
    }

    public String getDiscount2() {
        return this._discount2;
    }

    public void setDiscount2(String discount2) {
        this._discount2 = discount2;
    }

    public String getBandName() {
        return this._bandName;
    }

    public void setBandName(String bandName) {
        this._bandName = bandName;
    }

    public boolean isSalesTax() {
        return this._salesTax;
    }

    public void setSalesTax(boolean salesTax) {
        this._salesTax = salesTax;
    }

    public String calcPrice() {
        int i;
        String car = this.getCar();
        Color color = this.getColor();
        if (car == null || color == null) {
            this._price = new BigDecimal(0);
            return "ok";
        }
        BigDecimal carprice = (BigDecimal)_priceList.get(car);
        BigDecimal colorfactor = (BigDecimal)_priceFactorColors.get(color.getColor());
        if (carprice == null || colorfactor == null) {
            this._price = new BigDecimal(0);
            return "ok";
        }
        this._price = carprice.multiply(colorfactor);
        String[] extras = this.getExtras();
        if (extras != null) {
            for (i = 0; i < extras.length; ++i) {
                String extra = extras[i];
                this._price = this._price.add((BigDecimal)_priceListExtras.get(extra));
            }
        }
        if (this._discount != null) {
            try {
                i = Integer.parseInt(this._discount);
                switch (i) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this._price = this._price.multiply(new BigDecimal(0.95));
                        break;
                    }
                    case 2: {
                        this._price = this._price.multiply(new BigDecimal(0.91));
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this._discount2 != null) {
            try {
                int i2 = Integer.parseInt(this._discount2);
                switch (i2) {
                    case 1: {
                        this._price = this._price.multiply(new BigDecimal(0.85));
                        break;
                    }
                    case 2: {
                        this._price = this._price.multiply(new BigDecimal(0.8));
                        break;
                    }
                    case 3: {
                        this._price = this._price.multiply(new BigDecimal(0.6));
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this._salesTax) {
            this._price = this._price.multiply(new BigDecimal(1.2));
        }
        return "ok";
    }

    public void validateCar(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value instanceof String && value.equals("c6")) {
            throw new ValidatorException(new FacesMessage("Are you kidding?", "You cannot buy a James Blond car!"));
        }
    }

    public Converter getColorConverter() {
        return new ColorConverter();
    }

    static {
        _priceList = new HashMap();
        _priceFactorColors = new HashMap();
        _priceListExtras = new HashMap();
        _cars = new ArrayList();
        _colors = new ArrayList();
        _extrasList = new ArrayList();
        _cars.add(new SelectItem((Object)"c1", "Audee X6", null));
        _cars.add(new SelectItem((Object)"c2", "PMW 321u", null));
        _cars.add(new SelectItem((Object)"c3", "Masta ZX7", null));
        _cars.add(new SelectItem((Object)"c4", "Renolt ESP", null));
        _cars.add(new SelectItem((Object)"c5", "WV Lumpo", null));
        _cars.add(new SelectItem((Object)"c6", "James Blond Car", null));
        _cars.add(new SelectItem((Object)"c7", "Neko Bus", null));
        _colors.add(new LocalizedSelectItem((Object)new Color("color_black"), "color_black"));
        _colors.add(new LocalizedSelectItem((Object)new Color("color_blue"), "color_blue"));
        _colors.add(new LocalizedSelectItem((Object)new Color("color_marine"), "color_marine"));
        _colors.add(new LocalizedSelectItem((Object)new Color("color_red"), "color_red"));
        _extrasList.add(new LocalizedSelectItem("extra_aircond"));
        _extrasList.add(new LocalizedSelectItem("extra_sideab"));
        _extrasList.add(new LocalizedSelectItem("extra_mirrowheat"));
        _extrasList.add(new LocalizedSelectItem("extra_leaderseat"));
        _priceList.put("c1", new BigDecimal(30000));
        _priceList.put("c2", new BigDecimal(32000));
        _priceList.put("c3", new BigDecimal(20000));
        _priceList.put("c4", new BigDecimal(25000));
        _priceList.put("c5", new BigDecimal(10000));
        _priceList.put("c6", new BigDecimal(100000000));
        _priceList.put("c7", new BigDecimal(1000000000));
        _priceFactorColors.put("color_black", new BigDecimal(1.15));
        _priceFactorColors.put("color_blue", new BigDecimal(1.1));
        _priceFactorColors.put("color_marine", new BigDecimal(1.05));
        _priceFactorColors.put("color_red", new BigDecimal(1.0));
        _priceListExtras.put("extra_aircond", new BigDecimal(510));
        _priceListExtras.put("extra_sideab", new BigDecimal(1220));
        _priceListExtras.put("extra_mirrowheat", new BigDecimal(1230));
        _priceListExtras.put("extra_leaderseat", new BigDecimal(840));
    }
}

