/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.component;

/**
 * 
 * @since 1.1.7
 * @author Leonardo Uribe (latest modification by $Author: lu4242 $)
 * @version $Revision: 691856 $ $Date: 2008-09-04 04:40:30 +0200 (Thu, 04 Sep 2008) $
 */
public interface LocationAware
{

    /**
     *  An alternate location to find javascript resources. 
     *  If no values is specified, javascript will be loaded 
     *  from the resources directory using AddResource and 
     *  ExtensionsFilter.
     * 
     * @JSFProperty 
     */
    public String getJavascriptLocation();
    
    /**
     * An alternate location to find image resources. If no 
     * values is specified, images will be loaded from the 
     * resources directory using AddResource and ExtensionsFilter.
     * 
     * @JSFProperty 
     */
    public String getImageLocation();
    
    /**
     * An alternate location to find stylesheet resources. If no 
     * values is specified, stylesheets will be loaded from the 
     * resources directory using AddResource and ExtensionsFilter.
     * 
     * @JSFProperty 
     */
    public String getStyleLocation();
    
}
