/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.examples.crosstable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import org.apache.myfaces.examples.crosstable.DataBean;
import org.apache.myfaces.examples.listexample.SimpleCountry;
import org.apache.myfaces.examples.listexample.SimpleCountryList;

public class DataBean
extends SimpleCountryList {
    private DataModel mColumns;
    private DataModel mCountryDataModel;
    private Map mValueMap = new HashMap();
    private boolean mEditValues;
    private String mColumnLabel;

    public boolean isEditValues() {
        return this.mEditValues;
    }

    public String editValues() {
        this.mEditValues = true;
        return null;
    }

    public String saveValues() {
        this.mEditValues = false;
        return null;
    }

    public String addColumn() {
        if (this.mColumnLabel != null) {
            List columns = (List)this.getColumnDataModel().getWrappedData();
            columns.add(this.mColumnLabel);
        }
        return null;
    }

    public String removeColumn() {
        if (this.mColumns != null && this.mColumns.isRowAvailable()) {
            Object column = this.mColumns.getRowData();
            List columns = (List)this.getColumnDataModel().getWrappedData();
            columns.remove(column);
        }
        return null;
    }

    public String getColumnLabel() {
        return this.mColumnLabel;
    }

    public void setColumnLabel(String label) {
        this.mColumnLabel = label;
    }

    public DataModel getCountryDataModel() {
        if (this.mCountryDataModel == null) {
            this.mCountryDataModel = new ListDataModel(this.getCountries());
        }
        return this.mCountryDataModel;
    }

    public DataModel getColumnDataModel() {
        if (this.mColumns == null) {
            String[] result = new String[]{"2002", "2003", "2004"};
            this.mColumns = new ListDataModel(new ArrayList<String>(Arrays.asList(result)));
        }
        return this.mColumns;
    }

    public String getColumnValue() {
        DataModel countryDataModel = this.getCountryDataModel();
        if (countryDataModel.isRowAvailable()) {
            SimpleCountry row = (SimpleCountry)countryDataModel.getRowData();
            DataModel columnDataModel = this.getColumnDataModel();
            if (columnDataModel.isRowAvailable()) {
                Object column = columnDataModel.getRowData();
                RowColumnKey key = new RowColumnKey(this, (Object)new Long(row.getId()), column);
                if (!this.mValueMap.containsKey(key)) {
                    String randomValue = String.valueOf((int)(Math.random() * 5000.0) + 5000);
                    this.mValueMap.put(key, randomValue);
                }
                return (String)this.mValueMap.get(key);
            }
        }
        return null;
    }

    public void setColumnValue(String value) {
        DataModel countryDataModel = this.getCountryDataModel();
        if (countryDataModel.isRowAvailable()) {
            SimpleCountry row = (SimpleCountry)countryDataModel.getRowData();
            DataModel columnDataModel = this.getColumnDataModel();
            if (columnDataModel.isRowAvailable()) {
                Object column = columnDataModel.getRowData();
                RowColumnKey key = new RowColumnKey(this, (Object)new Long(row.getId()), column);
                this.mValueMap.put(key, value);
            }
        }
    }
}

