/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.examples.listexample;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.examples.listexample.SimpleCity;

public class SimpleCountry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long _id;
    private String _name;
    private String _isoCode;
    private BigDecimal _size;
    private boolean _remove = false;
    private List _cities;
    private String mSortCitiesColumn;
    private boolean mIsSortCitiesAscending;

    public SimpleCountry(long id, String name, String isoCode, BigDecimal size, SimpleCity[] cities) {
        this._id = id;
        this._name = name;
        this._isoCode = isoCode;
        this._size = size;
        this._cities = cities != null ? new ArrayList<SimpleCity>(Arrays.asList(cities)) : new ArrayList();
    }

    public long getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getIsoCode() {
        return this._isoCode;
    }

    public BigDecimal getSize() {
        return this._size;
    }

    public List getCities() {
        if (this.mSortCitiesColumn != null) {
            Collections.sort(this._cities, new /* Unavailable Anonymous Inner Class!! */);
        }
        return this._cities;
    }

    public void setId(long id) {
        this._id = id;
    }

    public void setIsoCode(String isoCode) {
        this._isoCode = isoCode;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setSize(BigDecimal size) {
        this._size = size;
    }

    public boolean isRemove() {
        return this._remove;
    }

    public void setRemove(boolean remove) {
        this._remove = remove;
    }

    public String addCity() {
        this.getCities().add(new SimpleCity());
        return null;
    }

    public void deleteCity(ActionEvent ev) {
        HtmlDataTable datatable = this.findParentHtmlDataTable(ev.getComponent());
        this.getCities().remove(datatable.getRowIndex() + datatable.getFirst());
    }

    public void setSortCitiesColumn(String columnName) {
        this.mSortCitiesColumn = columnName;
    }

    public String getSortCitiesColumn() {
        return this.mSortCitiesColumn;
    }

    public boolean isSortCitiesAscending() {
        return this.mIsSortCitiesAscending;
    }

    public void setSortCitiesAscending(boolean isSortCitiesAscending) {
        this.mIsSortCitiesAscending = isSortCitiesAscending;
    }

    private HtmlDataTable findParentHtmlDataTable(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof HtmlDataTable) {
            return (HtmlDataTable)component;
        }
        return this.findParentHtmlDataTable(component.getParent());
    }
}

