/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.examples.schedule;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.myfaces.custom.schedule.model.DefaultScheduleEntry;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.model.ScheduleModel;
import org.apache.myfaces.custom.schedule.model.SimpleScheduleModel;

public class ScheduleExampleHandler
implements Serializable {
    private static final long serialVersionUID = -8815771399735333108L;
    private ScheduleModel model;

    public ScheduleModel getModel() {
        return this.model;
    }

    public void setModel(ScheduleModel model) {
        this.model = model;
    }

    public void deleteSelectedEntry(ActionEvent event) {
        if (this.model == null) {
            return;
        }
        this.model.removeSelectedEntry();
    }

    public void addSampleHoliday(ActionEvent event) {
        if (this.model instanceof SimpleScheduleModel) {
            SimpleScheduleModel ssm = (SimpleScheduleModel)this.model;
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(ssm.getSelectedDate());
            calendar.set(7, 5);
            ssm.setHoliday(calendar.getTime(), "Poeperkesdag");
            ssm.refresh();
        }
    }

    public void addSampleEntries(ActionEvent event) {
        if (this.model == null) {
            return;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(this.model.getSelectedDate());
        calendar.set(7, 3);
        calendar.set(11, 14);
        DefaultScheduleEntry entry1 = new DefaultScheduleEntry();
        entry1.setId(RandomStringUtils.randomNumeric((int)32));
        entry1.setStartTime(calendar.getTime());
        calendar.add(12, 45);
        entry1.setEndTime(calendar.getTime());
        entry1.setTitle("Test MyFaces schedule component");
        entry1.setSubtitle("my office");
        entry1.setDescription("We need to get this thing out of the sandbox ASAP");
        this.model.addEntry((ScheduleEntry)entry1);
        DefaultScheduleEntry entry2 = new DefaultScheduleEntry();
        entry2.setId(RandomStringUtils.randomNumeric((int)32));
        calendar.add(12, -20);
        entry2.setStartTime(calendar.getTime());
        calendar.add(10, 2);
        entry2.setEndTime(calendar.getTime());
        entry2.setTitle("Show schedule component to boss");
        entry2.setSubtitle("my office");
        entry2.setDescription("Convince him to get time to thoroughly test it");
        this.model.addEntry((ScheduleEntry)entry2);
        DefaultScheduleEntry entry3 = new DefaultScheduleEntry();
        entry3.setId(RandomStringUtils.randomNumeric((int)32));
        calendar.add(5, 1);
        calendar.set(11, 9);
        calendar.set(12, 0);
        calendar.set(13, 0);
        entry3.setStartTime(calendar.getTime());
        calendar.set(11, 17);
        entry3.setEndTime(calendar.getTime());
        entry3.setTitle("Thoroughly test schedule component");
        this.model.addEntry((ScheduleEntry)entry3);
        DefaultScheduleEntry entry4 = new DefaultScheduleEntry();
        entry4.setId(RandomStringUtils.randomNumeric((int)32));
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 11);
        entry4.setStartTime(calendar.getTime());
        calendar.set(11, 14);
        entry4.setEndTime(calendar.getTime());
        entry4.setTitle("Long lunch");
        this.model.addEntry((ScheduleEntry)entry4);
        DefaultScheduleEntry entry5 = new DefaultScheduleEntry();
        entry5.setId(RandomStringUtils.randomNumeric((int)32));
        calendar.add(2, 2);
        calendar.set(5, 1);
        calendar.set(11, 1);
        entry5.setStartTime(calendar.getTime());
        calendar.set(11, 5);
        entry5.setEndTime(calendar.getTime());
        entry5.setTitle("Fishing trip");
        this.model.addEntry((ScheduleEntry)entry5);
        DefaultScheduleEntry entry6 = new DefaultScheduleEntry();
        calendar.setTime(this.model.getSelectedDate());
        calendar.set(7, 6);
        calendar.set(11, 16);
        entry6.setId(RandomStringUtils.randomNumeric((int)32));
        entry6.setStartTime(calendar.getTime());
        entry6.setEndTime(calendar.getTime());
        entry6.setTitle("Zero length entry");
        entry6.setDescription("Is only rendered when the 'renderZeroLengthEntries' attribute is 'true'");
        this.model.addEntry((ScheduleEntry)entry6);
        DefaultScheduleEntry entry7 = new DefaultScheduleEntry();
        entry7.setId(RandomStringUtils.randomNumeric((int)32));
        entry7.setTitle("All day event");
        entry7.setSubtitle("This event renders as an all-day event");
        entry7.setAllDay(true);
        this.model.addEntry((ScheduleEntry)entry7);
        this.model.refresh();
    }
}

