/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.event.PollEvent;
import org.apache.myfaces.trinidad.model.DefaultBoundedRangeModel;
import org.apache.myfaces.trinidaddemo.ProgressBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressStepsBean
extends ProgressBean {
    private static List<String> _PROGRESS_STEPS;
    private static final Logger _LOG;

    public List<String> getProgressSteps() {
        return _PROGRESS_STEPS;
    }

    public void onPoll(PollEvent event) {
        if (this.__model != null && this.__model.getMaximum() <= this.__model.getValue()) {
            this.endProcess();
            try {
                ExternalContext ec = FacesContext.getCurrentInstance().getExternalContext();
                ec.redirect("../components/progressEnd.jspx?taskStatus=completed");
            }
            catch (IOException ioe) {
                _LOG.log(Level.WARNING, "Could not redirect", ioe);
            }
            catch (RuntimeException re) {
                _LOG.log(Level.SEVERE, "Could not redirect", re);
                throw re;
            }
        }
    }

    protected void prepare() {
        this.__model = new DefaultBoundedRangeModel(-1L, 6L);
        this.__processThread = new ProgressBean.ProcessThread((ProgressBean)this, 1500L, 1L);
        this.__processThread.start();
    }

    static {
        _LOG = Logger.getLogger(ProgressStepsBean.class.getName());
        _PROGRESS_STEPS = new ArrayList();
        _PROGRESS_STEPS.add("Checking for latest version");
        _PROGRESS_STEPS.add("Checking available disk space");
        _PROGRESS_STEPS.add("Copying files");
        _PROGRESS_STEPS.add("Analyzing dependencies");
        _PROGRESS_STEPS.add("Install in progress");
        _PROGRESS_STEPS.add("Building icons and shortcuts");
    }
}

