/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.email;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.myfaces.trinidaddemo.email.MessageData;

public class MessageDataModel
extends DataModel {
    private Folder _folder;
    private int _rowIndex;
    private int _count;
    private int _blockSize;
    private MessageData[] _loaded;
    private FetchProfile _fetchProfile;
    private static final Logger _LOG = Logger.getLogger(MessageDataModel.class.getName());

    public MessageDataModel(Folder folder, FetchProfile fetchProfile, int blockSize) {
        this.setWrappedData((Object)folder);
        this._blockSize = blockSize;
        this._fetchProfile = fetchProfile;
    }

    public int getRowCount() {
        return this._count;
    }

    public boolean isRowAvailable() {
        int index = this.getRowIndex();
        return index >= 0 && index < this.getRowCount();
    }

    public Object getRowData() {
        if (!this.isRowAvailable()) {
            return null;
        }
        int index = this.getRowIndex();
        this.pageInRowIndex(index);
        return this._loaded[index];
    }

    public void setRowIndex(int index) {
        if (index < -1) {
            throw new IllegalArgumentException();
        }
        this._rowIndex = index;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public Object getWrappedData() {
        return this._folder;
    }

    public void setWrappedData(Object data) {
        Folder newFolder;
        this._folder = newFolder = (Folder)data;
        this._rowIndex = -1;
        if (newFolder != null) {
            try {
                this._count = this._folder.getMessageCount();
            }
            catch (MessagingException me) {
                this._count = 0;
                _LOG.log(Level.SEVERE, "Could not get message count", me);
            }
        } else {
            this._count = 0;
        }
        this._loaded = new MessageData[this._count];
    }

    private int _getFlippedIndex(int index) {
        return this.getRowCount() - index - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageInRowIndex(int index) {
        if (this._loaded[index] == null) {
            try {
                if (_LOG.isLoggable(Level.FINEST)) {
                    _LOG.finest("total messages before open:" + this._folder.getMessageCount());
                }
                this._folder.open(1);
                this._count = this._folder.getMessageCount();
                int fromIndex = index / this._blockSize * this._blockSize;
                int toIndex = fromIndex + this._blockSize - 1;
                if (toIndex >= this._count) {
                    toIndex = this._count - 1;
                }
                try {
                    int jmFromIndex = this._getFlippedIndex(toIndex) + 1;
                    int jmToIndex = this._getFlippedIndex(fromIndex) + 1;
                    if (_LOG.isLoggable(Level.FINEST)) {
                        _LOG.finest("fetching messages from:" + jmFromIndex + " to:" + jmToIndex + " total:" + this.getRowCount() + " actual total:" + this._folder.getMessageCount());
                    }
                    Message[] messages = this._folder.getMessages(jmFromIndex, jmToIndex);
                    this._folder.fetch(messages, this._fetchProfile);
                    for (int i = 0; i < messages.length; ++i) {
                        Message message = messages[messages.length - i - 1];
                        this._loaded[i + fromIndex] = new MessageData(message);
                    }
                }
                finally {
                    this._folder.close(false);
                }
            }
            catch (MessagingException me) {
                _LOG.log(Level.SEVERE, me.getMessage(), me);
                FacesMessage errorMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, me.getMessage(), me.getStackTrace().toString());
                FacesContext context = FacesContext.getCurrentInstance();
                context.addMessage(null, errorMessage);
            }
        }
    }
}

