/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.email;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.model.DataModel;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.MessagingException;
import org.apache.myfaces.trinidaddemo.email.AccountData;
import org.apache.myfaces.trinidaddemo.email.MessageDataModel;

/*
 * Exception performing whole class analysis ignored.
 */
public class FolderData {
    private List<Object> _subFolders = null;
    private DataModel _messageListModel = null;
    private final Folder _folder;
    private final AccountData _accountData;
    private final boolean _holdsMessages;
    private int _startIndex;
    private static final int _MESSAGE_LOAD_BLOCK_SIZE = 100;
    private static final Logger _LOG = Logger.getLogger(FolderData.class.getName());

    public FolderData(AccountData data, Folder folder) throws MessagingException {
        this._folder = folder;
        this._accountData = data;
        this._holdsMessages = (this._folder.getType() & 1) > 0;
    }

    public void flush() {
        this._messageListModel = null;
    }

    public boolean isHoldsMessages() {
        return this._holdsMessages;
    }

    public int getMessageCount() throws MessagingException {
        if (this._holdsMessages) {
            return this._folder.getMessageCount();
        }
        return 0;
    }

    public int getUnreadMessageCount() throws MessagingException {
        if (this._holdsMessages) {
            return this._folder.getUnreadMessageCount();
        }
        return 0;
    }

    public int getStartIndex() {
        return this._startIndex;
    }

    public void setStartIndex(int startIndex) {
        this._startIndex = startIndex;
    }

    public String getName() {
        return this._folder.getName();
    }

    public String getFullName() {
        return this._folder.getFullName();
    }

    public synchronized List<Object> getSubFolders() throws MessagingException {
        if (this._subFolders == Collections.EMPTY_LIST) {
            return null;
        }
        if (this._subFolders == null) {
            FolderData[] folders = FolderData.toFolderData((AccountData)this._accountData, (Folder[])this._folder.list());
            if (folders == null) {
                this._subFolders = Collections.EMPTY_LIST;
                return null;
            }
            this._subFolders = Arrays.asList((Object[])folders);
        }
        return this._subFolders;
    }

    public Object getMessageListModel() {
        if (this._holdsMessages) {
            if (this._messageListModel == null) {
                FetchProfile fetchProfile = new FetchProfile();
                fetchProfile.add(FetchProfile.Item.ENVELOPE);
                fetchProfile.add(FetchProfile.Item.FLAGS);
                this._messageListModel = new MessageDataModel(this._folder, fetchProfile, 100);
            }
            return this._messageListModel;
        }
        return null;
    }

    public static FolderData[] toFolderData(AccountData data, Folder[] folders) throws MessagingException {
        int sz = folders.length;
        if (sz > 0) {
            FolderData[] subs = new FolderData[sz];
            for (int i = 0; i < sz; ++i) {
                Folder f = folders[i];
                subs[i] = new FolderData(data, f);
            }
            return subs;
        }
        return null;
    }

    public Folder getFolder() {
        return this._folder;
    }

    public String viewMessages() {
        this._accountData.setCurrentFolder(this);
        _LOG.log(Level.FINE, "Showing messages for folder named {0} ", this.getName());
        return "messages";
    }
}

