/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.change;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.myfaces.trinidad.change.AddChildComponentChange;
import org.apache.myfaces.trinidad.change.AddChildDocumentChange;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.change.RemoveChildComponentChange;
import org.apache.myfaces.trinidad.change.RemoveFacetComponentChange;
import org.apache.myfaces.trinidad.change.ReorderChildrenComponentChange;
import org.apache.myfaces.trinidad.change.SetFacetChildComponentChange;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandButton;
import org.apache.myfaces.trinidad.component.core.output.CoreImage;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputFormatted;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChangeBean {
    private static final String[] _images = new String[]{"cobrand.gif", "corporateBrand.gif", "largeAd.gif", "mediumAd.gif", "new.gif"};
    private static final String[] _labels = new String[]{"Label One", "Label Two", "Label Three", "Label Four", "Label Five"};
    private static final String[] _texts = new String[]{"PanelBoxText One", "PanelBoxText Two", "PanelBoxText Three", "PanelBoxText Four", "PanelBoxText Five"};
    private static final String _IMAGE_MARK_UP = "<tr:Image id='oi3' inlineStyle='height: 100px; width: 120px;' source='http://homepage.mac.com/awiner/.Pictures/WindyHill/PaleSwallowtail.jpg' xmlns:af='http://myfaces.apache.org/adf/faces/EA17'/>";
    private static final Logger _LOG = Logger.getLogger(ChangeBean.class.getName());

    public void modifyObjectImage(ActionEvent event) {
        UIComponent uic = event.getComponent().findComponent("oi1");
        String source = "/components/images/" + _images[ChangeBean._getRandIndex()];
        uic.getAttributes().put("source", source);
        ChangeBean._addAttributeChange((UIComponent)uic, (String)"source", (Object)source);
    }

    public void modifyPanelBox(ActionEvent event) {
        UIComponent uic = event.getComponent().findComponent("pb1");
        String text = _texts[ChangeBean._getRandIndex()];
        uic.getAttributes().put("text", text);
        ChangeBean._addAttributeChange((UIComponent)uic, (String)"text", (Object)text);
    }

    public void modifyColumn(ActionEvent event) {
        UIComponent uic2 = event.getComponent().findComponent("t1");
        UIComponent uic = uic2.findComponent("c1");
        Object sortableAttrib = uic.getAttributes().get("sortable");
        Boolean isSortable = sortableAttrib == null ? Boolean.TRUE : (Boolean)sortableAttrib;
        Boolean newSortableValue = Boolean.TRUE.equals(isSortable) ? Boolean.FALSE : Boolean.TRUE;
        uic.getAttributes().put("sortable", newSortableValue);
        ChangeBean._addAttributeChange((UIComponent)uic, (String)"sortable", (Object)newSortableValue);
    }

    public void modifyInputText(ActionEvent event) {
        UIComponent uic = event.getComponent().findComponent("it1");
        String label = _labels[ChangeBean._getRandIndex()];
        uic.getAttributes().put("label", label);
        ChangeBean._addAttributeChange((UIComponent)uic, (String)"label", (Object)label);
    }

    public void appendChildToDocument(ActionEvent event) {
        UIComponent eventSource = event.getComponent();
        UIComponent uic = eventSource.findComponent("pg1");
        if (ChangeBean._findChildById((UIComponent)uic, (String)"oi3") != null) {
            return;
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        DocumentFragment imageFragment = ChangeBean._createDocumentFragment((String)"<tr:Image id='oi3' inlineStyle='height: 100px; width: 120px;' source='http://homepage.mac.com/awiner/.Pictures/WindyHill/PaleSwallowtail.jpg' xmlns:af='http://myfaces.apache.org/adf/faces/EA17'/>");
        if (imageFragment != null) {
            AddChildDocumentChange change = new AddChildDocumentChange(imageFragment);
            ChangeManager apm = RequestContext.getCurrentInstance().getChangeManager();
            apm.addDocumentChange(fc, uic, (DocumentChange)change);
        }
    }

    public void appendChild(ActionEvent event) {
        UIComponent eventSource = event.getComponent();
        UIComponent uic = eventSource.findComponent("pg1");
        if (ChangeBean._findChildById((UIComponent)uic, (String)"oi2") != null) {
            return;
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        CoreImage newChild = (CoreImage)fc.getApplication().createComponent("org.apache.myfaces.trinidad.CoreImage");
        newChild.setId("oi2");
        newChild.setInlineStyle("height: 100px, width: 120px");
        newChild.setSource("http://homepage.mac.com/awiner/.Pictures/WindyHill/PaleSwallowtail.jpg");
        uic.getChildren().add(newChild);
        AddChildComponentChange aca = new AddChildComponentChange((UIComponent)newChild);
        ChangeManager apm = RequestContext.getCurrentInstance().getChangeManager();
        apm.addComponentChange(fc, uic, (ComponentChange)aca);
    }

    public void addFacet(ActionEvent event) {
        UIComponent eventSource = event.getComponent();
        UIComponent uic = eventSource.findComponent("pp1");
        FacesContext fc = FacesContext.getCurrentInstance();
        CoreOutputFormatted newFacetComponent = (CoreOutputFormatted)fc.getApplication().createComponent("org.apache.myfaces.trinidad.CoreOutputFormatted");
        newFacetComponent.setStyleUsage("inContextBranding");
        newFacetComponent.setValue((Object)"Customer Company - Menlo Park");
        uic.getFacets().put("brandingAppContextual", newFacetComponent);
        SetFacetChildComponentChange afa = new SetFacetChildComponentChange("brandingAppContextual", (UIComponent)newFacetComponent);
        ChangeManager apm = RequestContext.getCurrentInstance().getChangeManager();
        apm.addComponentChange(fc, uic, (ComponentChange)afa);
    }

    public void reorderChildren(ActionEvent event) {
        UIComponent uic = event.getComponent().findComponent("pg1");
        int numChildren = uic.getChildCount();
        if (numChildren == 0) {
            return;
        }
        List children = uic.getChildren();
        Collections.reverse(children);
        ArrayList<String> reorderedChildIdList = new ArrayList<String>();
        for (UIComponent child : children) {
            reorderedChildIdList.add(child.getId());
        }
        ReorderChildrenComponentChange ra = new ReorderChildrenComponentChange(reorderedChildIdList);
        FacesContext fc = FacesContext.getCurrentInstance();
        ChangeManager apm = RequestContext.getCurrentInstance().getChangeManager();
        apm.addComponentChange(fc, uic, (ComponentChange)ra);
    }

    public void removeChildren(ActionEvent event) {
        UIComponent eventSource = event.getComponent();
        UIComponent uic = eventSource.findComponent("pg1");
        int numChildren = uic.getChildCount();
        if (numChildren == 0) {
            return;
        }
        String eventSourceId = eventSource.getId();
        if (eventSourceId.equals("cb2")) {
            ChangeBean._removeChild((UIComponent)uic, (String)"sic1");
            ChangeBean._removeChild((UIComponent)uic, (String)"cc1");
        } else if (eventSourceId.equals("cb3")) {
            ChangeBean._removeChild((UIComponent)uic, (String)"cd1");
            ChangeBean._removeChild((UIComponent)uic, (String)"sid1");
        }
    }

    public void removeFacets(ActionEvent event) {
        CoreCommandButton eventSource = (CoreCommandButton)event.getComponent();
        String facetNameFromButtonText = eventSource.getText().split(":")[0];
        String[] removableFacetNames = facetNameFromButtonText.split("_");
        UIComponent uic = eventSource.findComponent("pp1");
        Map facets = uic.getFacets();
        if (facets.keySet().size() == 0) {
            return;
        }
        for (int i = 0; i < removableFacetNames.length; ++i) {
            if (facets.get(removableFacetNames[i]) == null) continue;
            facets.remove(removableFacetNames[i]);
            RemoveFacetComponentChange rfa = new RemoveFacetComponentChange(removableFacetNames[i]);
            FacesContext fc = FacesContext.getCurrentInstance();
            ChangeManager apm = RequestContext.getCurrentInstance().getChangeManager();
            apm.addComponentChange(fc, uic, (ComponentChange)rfa);
        }
    }

    private static DocumentFragment _createDocumentFragment(String markUp) {
        DocumentBuilder builder;
        markUp = "<?xml version = '1.0' encoding = 'ISO-8859-1'?>" + markUp;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            _LOG.log(Level.WARNING, "Unable to get XML Parser:", pce);
            return null;
        }
        try {
            byte[] markupBytes = markUp.getBytes();
            Document newDoc = builder.parse(new ByteArrayInputStream(markupBytes));
            DocumentFragment fragment = newDoc.createDocumentFragment();
            fragment.appendChild(newDoc.getDocumentElement());
            return fragment;
        }
        catch (SAXException se) {
            _LOG.log(Level.WARNING, "Unable to parse markup:" + markUp, se);
            return null;
        }
        catch (IOException ioe) {
            _LOG.log(Level.WARNING, "IO Problem with markup:" + markUp, ioe);
            return null;
        }
    }

    private static void _removeChild(UIComponent uic, String removableChildId) {
        UIComponent removableChild = ChangeBean._findChildById((UIComponent)uic, (String)removableChildId);
        if (removableChild != null) {
            List children = uic.getChildren();
            children.remove(removableChild);
            RemoveChildComponentChange rca = new RemoveChildComponentChange(removableChildId);
            FacesContext fc = FacesContext.getCurrentInstance();
            ChangeManager apm = RequestContext.getCurrentInstance().getChangeManager();
            apm.addComponentChange(fc, uic, (ComponentChange)rca);
        }
    }

    private static UIComponent _findChildById(UIComponent uic, String id) {
        int numChildren = uic.getChildCount();
        if (numChildren == 0) {
            return null;
        }
        List children = uic.getChildren();
        UIComponent child = null;
        for (int i = 0; i < numChildren; ++i) {
            child = (UIComponent)children.get(i);
            if (!id.equals(child.getId())) continue;
            return child;
        }
        return null;
    }

    private static void _addAttributeChange(UIComponent uic, String attribName, Object attribValue) {
        FacesContext fc = FacesContext.getCurrentInstance();
        ChangeManager apm = RequestContext.getCurrentInstance().getChangeManager();
        AttributeComponentChange aa = new AttributeComponentChange(attribName, attribValue);
        apm.addComponentChange(fc, uic, (ComponentChange)aa);
    }

    private static int _getRandIndex() {
        return (int)(Math.random() * 10.0) / 2;
    }
}

