/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.email;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidaddemo.email.MessageData;

public class ShowMessageBackingBean {
    private MessageData _message;
    private Part _attachmentToDownload;
    private static final Logger _LOG = Logger.getLogger(ShowMessageBackingBean.class.getName());

    public ShowMessageBackingBean() {
        RequestContext afContext = RequestContext.getCurrentInstance();
        this.setMessage((MessageData)afContext.getPageFlowScope().get("message"));
    }

    public MessageData getMessage() {
        return this._message;
    }

    public void setAttachmentToDownload(Part attachment) {
        this._attachmentToDownload = attachment;
    }

    public Part getAttachmentToDownload() {
        return this._attachmentToDownload;
    }

    public void setMessage(MessageData message) {
        try {
            _LOG.log(Level.INFO, "Displaying message {0}", message.getSubject());
        }
        catch (MessagingException me) {
            _LOG.log(Level.SEVERE, "Can't get the subject", me);
        }
        this._message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadAttachment() throws IOException, MessagingException {
        String filename;
        if (this._attachmentToDownload == null) {
            _LOG.severe("No attachment available");
            return null;
        }
        this._message.getMessage().getFolder().open(1);
        InputStream in = this._attachmentToDownload.getInputStream();
        FacesContext context = FacesContext.getCurrentInstance();
        ServletResponse response = (ServletResponse)context.getExternalContext().getResponse();
        response.setContentType(this._attachmentToDownload.getContentType());
        int size = this._attachmentToDownload.getSize();
        if (size >= 0) {
            response.setContentLength(size);
        }
        if (_LOG.isLoggable(Level.INFO)) {
            _LOG.info("Downloading content+ [size=" + size + ",contentType=" + this._attachmentToDownload.getContentType() + "]");
        }
        if (response instanceof HttpServletResponse && (filename = this._attachmentToDownload.getFileName()) != null) {
            ((HttpServletResponse)response).setHeader("Content-disposition", "attachment; filename=\"" + filename + "\"");
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            try {
                int count;
                byte[] buffer = new byte[131072];
                while ((count = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, count);
                }
            }
            finally {
                context.responseComplete();
                out.close();
            }
        }
        finally {
            this._message.getMessage().getFolder().close(false);
        }
        return null;
    }
}

