/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.email;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidaddemo.email.AccountData;
import org.apache.myfaces.trinidaddemo.email.MessageUtils;
import org.apache.myfaces.trinidaddemo.email.NewMessageBackingBean;
import org.apache.myfaces.trinidaddemo.email.ShowMessageBackingBean;

/*
 * Exception performing whole class analysis ignored.
 */
public class NewMessageBackingBean {
    private AccountData _account;
    private String _subject;
    private String _to;
    private String _cc;
    private String _content;
    private UploadedFile _attachment1;
    private UploadedFile _attachment2;
    private UploadedFile _attachment3;
    private static final Logger _LOG = Logger.getLogger(ShowMessageBackingBean.class.getName());

    public void setAccount(AccountData account) {
        this._account = account;
    }

    public AccountData getAccount() {
        return this._account;
    }

    public void validateEmailList(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value == null) {
            return;
        }
        try {
            NewMessageBackingBean._getEmailList((String)value.toString());
        }
        catch (AddressException ae) {
            throw new ValidatorException(MessageUtils.getErrorMessage((FacesContext)context, (String)"EMAIL_LIST_ERROR", (Object[])new Object[]{ae.getRef()}));
        }
    }

    public String getTo() {
        return this._to;
    }

    public void setTo(String to) {
        this._to = to;
    }

    public String getCc() {
        return this._cc;
    }

    public void setCc(String cc) {
        this._cc = cc;
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        this._content = content;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public UploadedFile getAttachment1() {
        return this._attachment1;
    }

    public void setAttachment1(UploadedFile attachment1) {
        this._attachment1 = attachment1;
    }

    public UploadedFile getAttachment2() {
        return this._attachment2;
    }

    public void setAttachment2(UploadedFile attachment2) {
        this._attachment2 = attachment2;
    }

    public UploadedFile getAttachment3() {
        return this._attachment3;
    }

    public void setAttachment3(UploadedFile attachment3) {
        this._attachment3 = attachment3;
    }

    public String send() {
        Session session = this._getSession();
        Message msg = this._setupMessage((Message)new MimeMessage(session));
        if (msg == null) {
            _LOG.info("Could not create Message object for " + this.getSubject());
            return null;
        }
        try {
            Transport.send((Message)msg);
        }
        catch (MessagingException me) {
            this._showSendException((Exception)((Object)me));
            return null;
        }
        _LOG.info("Sent succesfully");
        try {
            Store store = this._account.getStore();
            Folder folder = store.getFolder("Sent");
            if (folder == null) {
                throw new IllegalStateException("\"Sent\" folder was null");
            }
            if (!folder.exists()) {
                folder.create(1);
            }
            folder.appendMessages(new Message[]{msg});
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Couldn't save message in \"Sent\" folder", e);
        }
        return "sentMessage";
    }

    private Session _getSession() {
        Properties props = new Properties(System.getProperties());
        if (this._account.getSmtpServer() != null) {
            props.put("mail.smtp.host", this._account.getSmtpServer());
        }
        return Session.getInstance((Properties)props, null);
    }

    public String saveAsDraft() {
        _LOG.info("Beginning send of message " + this.getSubject());
        Session session = this._getSession();
        Message msg = this._setupMessage((Message)new MimeMessage(session));
        if (msg == null) {
            _LOG.info("Could not create Message object for " + this.getSubject());
            return null;
        }
        try {
            Store store = this._account.getStore();
            Folder folder = store.getFolder("Drafts");
            if (folder == null) {
                throw new IllegalStateException("\"Drafts\" folder was null");
            }
            if (!folder.exists()) {
                folder.create(1);
            }
            folder.appendMessages(new Message[]{msg});
        }
        catch (Exception e) {
            this._showSendException(e);
            return null;
        }
        return "messages";
    }

    private Message _setupMessage(Message msg) {
        try {
            String username = this._account.getUsername();
            String from = username + "@" + this._account.getDomain();
            List to = NewMessageBackingBean._getEmailList((String)this.getTo());
            List cc = null;
            String ccString = this.getCc();
            if (ccString != null) {
                cc = NewMessageBackingBean._getEmailList((String)ccString);
            }
            msg.setFrom((Address)new InternetAddress(from));
            if (to != null && !to.isEmpty()) {
                msg.setRecipients(Message.RecipientType.TO, (Address[])to.toArray(new InternetAddress[0]));
            }
            if (cc != null && !cc.isEmpty()) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])cc.toArray(new InternetAddress[0]));
            }
            msg.setSubject(this._subject == null ? "" : this._subject);
            if (this._attachment1 == null && this._attachment2 == null && this._attachment3 == null) {
                msg.setText(this._content == null ? "" : this._content);
            } else {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setText(this._content == null ? "" : this._content);
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                if (this._attachment1 != null) {
                    this._addAttachment((Multipart)multipart, this._attachment1);
                }
                if (this._attachment2 != null) {
                    this._addAttachment((Multipart)multipart, this._attachment2);
                }
                if (this._attachment3 != null) {
                    this._addAttachment((Multipart)multipart, this._attachment3);
                }
                msg.setContent((Multipart)multipart);
            }
            String mailer = "OracleAdfEmailDemo";
            msg.setHeader("X-Mailer", mailer);
            msg.setSentDate(new Date());
            return msg;
        }
        catch (AddressException ae) {
            this._showSendException((Exception)((Object)ae));
        }
        catch (MessagingException me) {
            this._showSendException((Exception)((Object)me));
        }
        catch (Exception e) {
            this._showSendException(e);
        }
        return null;
    }

    private void _showSendException(Exception e) {
        FacesContext context = FacesContext.getCurrentInstance();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), null));
        _LOG.log(Level.WARNING, "Couldn't send message", e);
    }

    private void _addAttachment(Multipart multipart, UploadedFile file) throws MessagingException {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        UploadedFileDataSource source = new UploadedFileDataSource(file);
        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
        messageBodyPart.setFileName(file.getFilename());
        multipart.addBodyPart((BodyPart)messageBodyPart);
    }

    private static List<InternetAddress> _getEmailList(String values) throws AddressException {
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        StringTokenizer tokens = new StringTokenizer(values.toString(), ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            InternetAddress address = new InternetAddress(token);
            list.add(address);
        }
        return list;
    }

    static /* synthetic */ Logger access$000() {
        return _LOG;
    }
}

