/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.table;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TableBuilder
implements Serializable {
    private String _beanClass = null;
    private transient List<Object> _beanProps = Collections.EMPTY_LIST;
    private List<?> _data = Collections.EMPTY_LIST;
    private List<?> _result = null;

    public void setBeanClass(String klass) {
        this._beanClass = klass;
    }

    public void setBeanProperties(List<Object> props) {
        if (props == null) {
            throw new NullPointerException("beanProperties");
        }
        this._beanProps = props;
    }

    public void setBeanData(List<?> data) {
        if (data == null) {
            throw new NullPointerException("beanData");
        }
        this._data = data;
    }

    public List<?> getTableData() throws ClassNotFoundException, IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this._result == null) {
            this._result = this._getAsList();
        }
        return this._result;
    }

    private List<Object> _getAsList() throws ClassNotFoundException, IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this._beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        Class<?> beanClass = Class.forName(this._beanClass);
        this._setPropertySetters(beanClass, this._beanProps);
        int sz = this._beanProps.size();
        ArrayList<Object> result = new ArrayList<Object>(sz);
        Iterator cells = this._data.iterator();
        while (cells.hasNext()) {
            Object beanInstance = beanClass.newInstance();
            for (int i = 0; i < sz; ++i) {
                Object value = cells.next();
                Method setter = (Method)this._beanProps.get(i);
                Class<?> expectedType = setter.getParameterTypes()[0];
                if (!expectedType.isAssignableFrom(value.getClass())) {
                    value = this._convert(value, expectedType);
                }
                setter.invoke(beanInstance, value);
            }
            result.add(beanInstance);
        }
        return result;
    }

    private Object _convert(Object instance, Class<?> expectedType) {
        if (Integer.TYPE == expectedType) {
            return new Integer(instance.toString());
        }
        throw new IllegalArgumentException("Could not convert instance:" + instance + " of class:" + instance.getClass() + " into " + expectedType);
    }

    private void _setPropertySetters(Class<?> klass, List<Object> props) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(klass);
        PropertyDescriptor[] descs = beanInfo.getPropertyDescriptors();
        int sz = props.size();
        for (int i = 0; i < sz; ++i) {
            String name = (String)props.get(i);
            PropertyDescriptor desc = this._getDescriptor(descs, name);
            if (desc == null) {
                throw new IllegalArgumentException("property:" + name + " not found on:" + klass);
            }
            Method setter = desc.getWriteMethod();
            if (setter == null) {
                throw new IllegalArgumentException("No way to set property:" + name + " on:" + klass);
            }
            props.set(i, setter);
        }
    }

    private PropertyDescriptor _getDescriptor(PropertyDescriptor[] descs, String name) {
        for (int i = 0; i < descs.length; ++i) {
            PropertyDescriptor desc = descs[i];
            if (!name.equals(desc.getName())) continue;
            return desc;
        }
        return null;
    }
}

