/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.email;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidaddemo.email.MessageData;
import org.apache.myfaces.trinidaddemo.email.NewMessageBackingBean;

public class ReplyToMessageBackingBean
extends NewMessageBackingBean {
    private static final Logger _LOG = Logger.getLogger(ReplyToMessageBackingBean.class.getName());

    public ReplyToMessageBackingBean() {
        RequestContext afContext = RequestContext.getCurrentInstance();
        Object replyToAll = afContext.getPageFlowScope().get("replyToAll");
        this._setUpReplyToMessage("true".equals(replyToAll));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setUpReplyToMessage(boolean replyToAll) {
        RequestContext afContext = RequestContext.getCurrentInstance();
        MessageData message = (MessageData)afContext.getPageFlowScope().get("message");
        if (message == null) {
            return;
        }
        Message msg = message.getMessage();
        try {
            msg.getFolder().open(1);
            Message replyMessage = msg.reply(replyToAll);
            this.setSubject(replyMessage.getSubject());
            Address[] replyToAddresses = replyMessage.getAllRecipients();
            this.setTo(this._getAddressString(replyToAddresses));
        }
        catch (MessagingException e) {
            _LOG.log(Level.WARNING, "Couldn't create reply-to message", e);
        }
        finally {
            try {
                msg.getFolder().close(false);
            }
            catch (Exception exception) {}
        }
    }

    private String _getAddressString(Address[] replyToAddresses) {
        StringBuffer to = new StringBuffer(100);
        for (int i = 0; i < replyToAddresses.length; ++i) {
            if (i > 0) {
                to.append(",");
            }
            to.append(((InternetAddress)replyToAddresses[i]).getAddress());
        }
        return to.toString();
    }
}

