/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.tagDemos;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.ReorderChildrenComponentChange;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.model.RowKeyPropertyModel;
import org.apache.myfaces.trinidad.model.SortCriterion;
import org.apache.myfaces.trinidad.model.SortableModel;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidaddemo.tagDemos.ForEachBean;

public class ForEachBean
implements Serializable {
    private final List<Person> _simpleList;
    private final List<Person> _list = new ArrayList<Person>(Arrays.asList(new Person("a", "John", "Doe"), new Person("b", "Jane", "Doe"), new Person("c", "Bob", "Smith"), new Person("d", "Alice", "Jones")));
    private transient RowKeyPropertyModel _model = new RowKeyPropertyModel(new ArrayList(this._list), "key");
    private final Map<String, Person> _map;
    private final Map<String, UpdatableItem> _updatableItemMap;
    private final Map<String, Person> _arrangeMap;
    private String _currentExample = null;
    private String _sortProperty;
    private String _newPersonFirstName;
    private String _newPersonLastName;
    private boolean _sortAscending;
    private int _nextArrangePersonKey = 1;
    private transient List<SubFamily> _felineFamily;
    private static final long serialVersionUID = 3L;

    public ForEachBean() {
        this._simpleList = new ArrayList(this._list);
        this._map = new LinkedHashMap();
        this._applySortToNonCollectionModelObjects();
        this._arrangeMap = new LinkedHashMap(this._map);
        this._updatableItemMap = new LinkedHashMap();
        for (int i = 1; i <= 5; ++i) {
            String key = Integer.toString(i);
            String value = String.format("Item %d", i);
            this._updatableItemMap.put(key, new UpdatableItem(key, value));
        }
    }

    public void setNewPersonFirstName(String newPersonFirstName) {
        this._newPersonFirstName = newPersonFirstName;
    }

    public String getNewPersonFirstName() {
        return this._newPersonFirstName;
    }

    public void setNewPersonLastName(String newPersonLastName) {
        this._newPersonLastName = newPersonLastName;
    }

    public String getNewPersonLastName() {
        return this._newPersonLastName;
    }

    public final void setCurrentExample(String currentExample) {
        this._currentExample = currentExample;
    }

    public final String getCurrentExample() {
        return this._currentExample;
    }

    public final void setSortProperty(String sortProperty) {
        if ("".equals(sortProperty)) {
            sortProperty = null;
        }
        this._sortProperty = sortProperty;
    }

    public final String getSortProperty() {
        return this._sortProperty;
    }

    public final void setSortAscending(boolean sortAscending) {
        this._sortAscending = sortAscending;
    }

    public final boolean isSortAscending() {
        return this._sortAscending;
    }

    public List<Person> getList() {
        return this._list;
    }

    public List<Person> getSimpleList() {
        return this._simpleList;
    }

    public void updateSortOrder(ActionEvent evt) {
        RowKeyPropertyModel model = this._getCollectionModel();
        if (this._sortProperty == null) {
            model.setSortCriteria(null);
        } else {
            model.setSortCriteria(Collections.singletonList(new SortCriterion(this._sortProperty, this._sortAscending)));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        List orderedKeys = this._applySortToNonCollectionModelObjects();
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, Arrays.asList("r:personForEachMapParent", "r:personForEachModelParent"), null);
        facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Map<String, UpdatableItem> getUpdatableItemMap() {
        return this._updatableItemMap;
    }

    public Map<String, Person> getMap() {
        return this._map;
    }

    public Map<String, Person> getArrangeMap() {
        return this._arrangeMap;
    }

    public SortableModel getModel() {
        return this._getCollectionModel();
    }

    public final List<SubFamily> getFelineSubFamilies() {
        if (this._felineFamily == null) {
            this._felineFamily = Arrays.asList(new SubFamily("Pantherinae", new Genus[]{new Genus("Panthera", new Species[]{new Species("Lion", "Panthera leo", null), new Species("Jaguar", "Panthera onca", null), new Species("Leopard", "Panthera pardus", null), new Species("Tiger", "Panthera tigris", null)}, null), new Genus("Uncia", new Species[]{new Species("Snow Leopard", "Uncia uncia", null)}, null), new Genus("Neofelis", new Species[]{new Species("Clouded Leopard", "Neofelis nebulosa", null), new Species("Sunda Clouded Leopard", "Neofelis diardi", null)}, null)}, null), new SubFamily("Felinae", new Genus[]{new Genus("Pardofelis", new Species[]{new Species("Marbled Cat", "Pardofelis marmorata", null)}, null), new Genus("Catopuma", new Species[]{new Species("Bay Cat", "Catopuma badia", null), new Species("Asian Golden Cat", "Catopuma temminckii", null)}, null), new Genus("Leptailurus", new Species[]{new Species("Serval", "Leptailurus serval", null)}, null), new Genus("Caracal", new Species[]{new Species("Caracal", "Caracal caracal", null)}, null), new Genus("Profelis", new Species[]{new Species("African Golden Cat", "Profelis aurata", null)}, null), new Genus("Leopardus", new Species[]{new Species("Pantanal Cat", "Leopardus braccatus", null), new Species("Colocolo", "Leopardus colocolo", null), new Species("Geoffroy's Cat", "Leopardus geoffroyi", null), new Species("Kodkod", "Leopardus guigna", null), new Species("Andean Mountain Cat", "Leopardus jacobitus", null), new Species("Pampas Cat", "Leopardus pajeros", null), new Species("Ocelot", "Leopardus pardalis", null), new Species("Oncilla", "Leopardus tigrinus", null), new Species("Margay", "Leopardus wiedii", null)}, null), new Genus("Lynx", new Species[]{new Species("Canadian Lynx", "Lynx canadensis", null), new Species("Eurasian Lynx", "Lynx lynx", null), new Species("Iberian Lynx", "Lynx pardinus", null), new Species("Bobcat", "Lynx rufus", null)}, null), new Genus("Puma", new Species[]{new Species("Cougar", "Puma concolor", null), new Species("Jaguarundi", "Puma yagouaroundi", null)}, null), new Genus("Acinonyx", new Species[]{new Species("Cheetah", "Acinonyx jubatus", null)}, null), new Genus("Prionailurus", new Species[]{new Species("Leopard Cat", "Prionailurus bengalensis", null), new Species("Iriomote Cat", "Prionailurus bengalensis iriomotensis", null), new Species("Flat-headed Cat", "Prionailurus planiceps", null), new Species("Rusty-spotted Cat", "Prionailurus rubiginosus", null), new Species("Fishing Cat", "Prionailurus viverrinus", null)}, null), new Genus("Otocolobus", new Species[]{new Species("Pallas's Cat", "Otocolobus manul", null)}, null), new Genus("Felis", new Species[]{new Species("Chinese Mountain Cat", "Felis bieti", null), new Species("Domestic Cat", "Felis catus", null), new Species("Jungle Cat", "Felis chaus", null), new Species("Sand Cat", "Felis margarita", null), new Species("Black-footed Cat", "Felis nigripes", null), new Species("Wildcat", "Felis silvestris", null)}, null)}, null));
        }
        return this._felineFamily;
    }

    public void handleArrangeNewItem(ActionEvent evt) {
        UIComponent target = evt.getComponent();
        String forEachKey = (String)target.getAttributes().get("forEachKey");
        String newKey = "new" + this._nextArrangePersonKey++;
        if (forEachKey == null) {
            this._arrangeMap.put(newKey, new Person(newKey, this._newPersonFirstName, this._newPersonLastName));
        } else {
            LinkedHashMap mapCopy = new LinkedHashMap(this._arrangeMap);
            this._arrangeMap.clear();
            boolean added = false;
            for (Map.Entry entry : mapCopy.entrySet()) {
                String key = (String)entry.getKey();
                if (!added && forEachKey.equals(key)) {
                    this._arrangeMap.put(newKey, new Person(newKey, this._newPersonFirstName, this._newPersonLastName));
                    added = true;
                }
                this._arrangeMap.put(key, entry.getValue());
            }
            this._sortArrangedDemoChildren(target);
        }
        this._newPersonFirstName = null;
        this._newPersonLastName = null;
    }

    public void handleArrangeRemoveItem(ActionEvent evt) {
        UIComponent target = evt.getComponent();
        String forEachKey = (String)target.getAttributes().get("forEachKey");
        this._arrangeMap.remove(forEachKey);
        RequestContext.getCurrentInstance().addPartialTargets(target, new String[]{"::forEachParent"});
    }

    public void handleArrangeMoveItemUp(ActionEvent evt) {
        UIComponent target = evt.getComponent();
        String forEachKey = (String)target.getAttributes().get("forEachKey");
        this._moveItem(forEachKey, true);
        this._sortArrangedDemoChildren(target);
    }

    public void handleArrangeMoveItemDown(ActionEvent evt) {
        UIComponent target = evt.getComponent();
        String forEachKey = (String)target.getAttributes().get("forEachKey");
        this._moveItem(forEachKey, false);
        this._sortArrangedDemoChildren(target);
    }

    private void _moveItem(String keyToMove, boolean moveUp) {
        String key;
        int index = 0;
        Iterator i$ = this._arrangeMap.keySet().iterator();
        while (i$.hasNext() && !keyToMove.equals(key = (String)i$.next())) {
            ++index;
        }
        int n = moveUp ? -1 : 1;
        Person personToMove = (Person)this._arrangeMap.remove(keyToMove);
        if ((index += n) == this._arrangeMap.size()) {
            this._arrangeMap.put(keyToMove, personToMove);
        } else {
            LinkedHashMap mapCopy = new LinkedHashMap(this._arrangeMap);
            this._arrangeMap.clear();
            int i = 0;
            for (Map.Entry entry : mapCopy.entrySet()) {
                if (i++ == index) {
                    this._arrangeMap.put(keyToMove, personToMove);
                }
                this._arrangeMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void _sortArrangedDemoChildren(UIComponent target) {
        UIComponent forEachParent = ComponentUtils.findRelativeComponent((UIComponent)target, (String)"::forEachParent");
        this._addReorderChange(forEachParent, new ArrayList(this._arrangeMap.keySet()), "sv_");
    }

    private void _addReorderChange(UIComponent forEachParentComponent, List<String> desiredKeyOrder, String subviewPrefix) {
        ArrayList<String> orderedIds = new ArrayList<String>(desiredKeyOrder.size());
        for (String key : desiredKeyOrder) {
            orderedIds.add(subviewPrefix + key);
        }
        ReorderChildrenComponentChange componentChange = new ReorderChildrenComponentChange(orderedIds);
        RequestContext requestContext = RequestContext.getCurrentInstance();
        ChangeManager cm = requestContext.getChangeManager();
        cm.addComponentChange(FacesContext.getCurrentInstance(), forEachParentComponent, (ComponentChange)componentChange);
        requestContext.addPartialTarget(forEachParentComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _applySortToNonCollectionModelObjects() {
        RowKeyPropertyModel model = this._getCollectionModel();
        Object origRowKey = model.getRowKey();
        ArrayList<String> orderedKeys = new ArrayList<String>(model.getRowCount());
        this._list.clear();
        this._map.clear();
        try {
            model.setRowIndex(0);
            while (model.isRowAvailable()) {
                Person person = (Person)model.getRowData();
                orderedKeys.add(person.getKey());
                this._list.add(person);
                this._map.put(person.getKey(), person);
                model.setRowIndex(this._model.getRowIndex() + 1);
            }
        }
        finally {
            try {
                model.setRowKey(origRowKey);
            }
            catch (Throwable throwable) {}
        }
        return orderedKeys;
    }

    private RowKeyPropertyModel _getCollectionModel() {
        if (this._model == null) {
            this._model = new RowKeyPropertyModel(new ArrayList(this._list), "key");
            if (this._sortProperty == null) {
                this._model.setSortCriteria(null);
            } else {
                this._model.setSortCriteria(Collections.singletonList(new SortCriterion(this._sortProperty, this._sortAscending)));
            }
        }
        return this._model;
    }

    static /* synthetic */ void access$000(ForEachBean x0, UIComponent x1, List x2, String x3) {
        x0._addReorderChange(x1, x2, x3);
    }
}

