/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen.variant;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidad.util.Range;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.skin.AgentAtRuleMatcher;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.ApplicationAndVersion;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.SkinVariantExtractor;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

final class AgentVariantExtractor
implements SkinVariantExtractor<ApplicationAndVersion> {
    private final Map<TrinidadAgent.Application, Set<Version>> _appVersionsMap = new HashMap<TrinidadAgent.Application, Set<Version>>();
    private final Collection<TrinidadAgent.Application> _supportedApplications;
    private static final Version _UNKNOWN_VERSION = new Version("unknown");

    public AgentVariantExtractor(Collection<TrinidadAgent.Application> supportedApplications) {
        this._supportedApplications = this._initSupportedApplications(supportedApplications);
        this._addApplicationIfSupported(TrinidadAgent.Application.UNKNOWN);
    }

    private Collection<TrinidadAgent.Application> _initSupportedApplications(Collection<TrinidadAgent.Application> supportedApplications) {
        if (supportedApplications == null || supportedApplications.isEmpty()) {
            return new AbstractCollection<TrinidadAgent.Application>(){

                @Override
                public boolean contains(Object o) {
                    return true;
                }

                @Override
                public Iterator<TrinidadAgent.Application> iterator() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int size() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new HashSet<TrinidadAgent.Application>(supportedApplications);
    }

    @Override
    public void visit(StyleSheetNode node) {
        AgentAtRuleMatcher agentMatcher = node.getAgentMatcher();
        if (agentMatcher != null) {
            this._addApplicationVersions(agentMatcher);
        }
    }

    @Override
    public List<ApplicationAndVersion> getVariants() {
        List<ApplicationAndVersion> appAndVersionsList = AgentVariantExtractor._toAppAndVersionsList(this._appVersionsMap);
        return appAndVersionsList;
    }

    private void _addApplicationVersions(AgentAtRuleMatcher agentMatcher) {
        assert (agentMatcher != null);
        Collection<TrinidadAgent.Application> nodeApplications = agentMatcher.getAllApplications();
        for (TrinidadAgent.Application application : nodeApplications) {
            boolean supported = this._addApplicationIfSupported(application);
            if (!supported) continue;
            Collection<Range<Version>> versionRanges = agentMatcher.getAllVersionsForApplication(application);
            this._addVersions(application, versionRanges);
        }
    }

    private boolean _addApplicationIfSupported(TrinidadAgent.Application application) {
        if (!this._supportedApplications.contains((Object)application)) {
            return false;
        }
        if (!this._appVersionsMap.containsKey((Object)application)) {
            TreeSet<Version> versions = new TreeSet<Version>();
            versions.add(_UNKNOWN_VERSION);
            this._appVersionsMap.put(application, versions);
        }
        return true;
    }

    private void _addVersions(TrinidadAgent.Application application, Collection<Range<Version>> versionRanges) {
        Collection versions = this._appVersionsMap.get((Object)application);
        assert (versions != null);
        for (Range<Version> versionRange : versionRanges) {
            versions.add(((Version)versionRange.getStart()).toMinimumVersion());
            versions.add(((Version)versionRange.getEnd()).toMaximumVersion());
        }
    }

    private static List<ApplicationAndVersion> _toAppAndVersionsList(Map<TrinidadAgent.Application, Set<Version>> appVersionsMap) {
        ArrayList<ApplicationAndVersion> appAndVersions = new ArrayList<ApplicationAndVersion>();
        for (Map.Entry<TrinidadAgent.Application, Set<Version>> entry : appVersionsMap.entrySet()) {
            for (Version version : entry.getValue()) {
                appAndVersions.add(new ApplicationAndVersion(entry.getKey(), version));
            }
        }
        Collections.sort(appAndVersions);
        return appAndVersions;
    }
}

