/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status;

import org.apache.nifi.controller.status.FlowFileAvailability;
import org.apache.nifi.controller.status.analytics.ConnectionStatusPredictions;
import org.apache.nifi.processor.DataUnit;

public class ConnectionStatus
implements Cloneable {
    private String id;
    private String groupId;
    private String name;
    private String sourceId;
    private String sourceName;
    private String destinationId;
    private String destinationName;
    private String backPressureDataSizeThreshold;
    private ConnectionStatusPredictions predictions;
    private long backPressureBytesThreshold;
    private long backPressureObjectThreshold;
    private int inputCount;
    private long inputBytes;
    private int queuedCount;
    private long queuedBytes;
    private int outputCount;
    private long outputBytes;
    private int maxQueuedCount;
    private long maxQueuedBytes;
    private long totalQueuedDuration;
    private long maxQueuedDuration;
    private FlowFileAvailability flowFileAvailability;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getQueuedCount() {
        return this.queuedCount;
    }

    public void setQueuedCount(int queuedCount) {
        this.queuedCount = queuedCount;
    }

    public long getQueuedBytes() {
        return this.queuedBytes;
    }

    public void setQueuedBytes(long queuedBytes) {
        this.queuedBytes = queuedBytes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getBackPressureDataSizeThreshold() {
        return this.backPressureDataSizeThreshold;
    }

    public void setBackPressureDataSizeThreshold(String backPressureDataSizeThreshold) {
        this.backPressureDataSizeThreshold = backPressureDataSizeThreshold;
        this.setBackPressureBytesThreshold(DataUnit.parseDataSize(backPressureDataSizeThreshold, DataUnit.B).longValue());
    }

    public ConnectionStatusPredictions getPredictions() {
        return this.predictions;
    }

    public void setPredictions(ConnectionStatusPredictions predictions) {
        this.predictions = predictions;
    }

    public long getBackPressureObjectThreshold() {
        return this.backPressureObjectThreshold;
    }

    public void setBackPressureObjectThreshold(long backPressureObjectThreshold) {
        this.backPressureObjectThreshold = backPressureObjectThreshold;
    }

    public long getInputBytes() {
        return this.inputBytes;
    }

    public void setInputBytes(long inputBytes) {
        this.inputBytes = inputBytes;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public void setInputCount(int inputCount) {
        this.inputCount = inputCount;
    }

    public long getOutputBytes() {
        return this.outputBytes;
    }

    public void setOutputBytes(long outputBytes) {
        this.outputBytes = outputBytes;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public int getMaxQueuedCount() {
        return this.maxQueuedCount;
    }

    public void setMaxQueuedCount(int maxQueuedCount) {
        this.maxQueuedCount = maxQueuedCount;
    }

    public long getMaxQueuedBytes() {
        return this.maxQueuedBytes;
    }

    public void setMaxQueuedBytes(long maxQueueBytes) {
        this.maxQueuedBytes = maxQueueBytes;
    }

    public long getBackPressureBytesThreshold() {
        return this.backPressureBytesThreshold;
    }

    public void setBackPressureBytesThreshold(long backPressureBytesThreshold) {
        this.backPressureBytesThreshold = backPressureBytesThreshold;
    }

    public long getTotalQueuedDuration() {
        return this.totalQueuedDuration;
    }

    public void setTotalQueuedDuration(long totalQueuedDuration) {
        this.totalQueuedDuration = totalQueuedDuration;
    }

    public long getMaxQueuedDuration() {
        return this.maxQueuedDuration;
    }

    public void setMaxQueuedDuration(long maxQueuedDuration) {
        this.maxQueuedDuration = maxQueuedDuration;
    }

    public FlowFileAvailability getFlowFileAvailability() {
        return this.flowFileAvailability;
    }

    public void setFlowFileAvailability(FlowFileAvailability availability) {
        this.flowFileAvailability = availability;
    }

    public ConnectionStatus clone() {
        ConnectionStatus clonedObj = new ConnectionStatus();
        clonedObj.groupId = this.groupId;
        clonedObj.id = this.id;
        clonedObj.inputBytes = this.inputBytes;
        clonedObj.inputCount = this.inputCount;
        clonedObj.name = this.name;
        clonedObj.outputBytes = this.outputBytes;
        clonedObj.outputCount = this.outputCount;
        clonedObj.queuedBytes = this.queuedBytes;
        clonedObj.queuedCount = this.queuedCount;
        clonedObj.sourceId = this.sourceId;
        clonedObj.sourceName = this.sourceName;
        clonedObj.destinationId = this.destinationId;
        clonedObj.destinationName = this.destinationName;
        clonedObj.flowFileAvailability = this.flowFileAvailability;
        if (this.predictions != null) {
            clonedObj.setPredictions(this.predictions.clone());
        }
        clonedObj.backPressureDataSizeThreshold = this.backPressureDataSizeThreshold;
        clonedObj.backPressureObjectThreshold = this.backPressureObjectThreshold;
        clonedObj.maxQueuedBytes = this.maxQueuedBytes;
        clonedObj.maxQueuedCount = this.maxQueuedCount;
        clonedObj.totalQueuedDuration = this.totalQueuedDuration;
        clonedObj.maxQueuedDuration = this.maxQueuedDuration;
        return clonedObj;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConnectionStatus [id=");
        builder.append(this.id);
        builder.append(", groupId=");
        builder.append(this.groupId);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", sourceId=");
        builder.append(this.sourceId);
        builder.append(", sourceName=");
        builder.append(this.sourceName);
        builder.append(", destinationId=");
        builder.append(this.destinationId);
        builder.append(", destinationName=");
        builder.append(this.destinationName);
        builder.append(", backPressureDataSizeThreshold=");
        builder.append(this.backPressureDataSizeThreshold);
        builder.append(", backPressureObjectThreshold=");
        builder.append(this.backPressureObjectThreshold);
        builder.append(", flowFileAvailability=");
        builder.append((Object)this.flowFileAvailability);
        builder.append(", inputCount=");
        builder.append(this.inputCount);
        builder.append(", inputBytes=");
        builder.append(this.inputBytes);
        builder.append(", queuedCount=");
        builder.append(this.queuedCount);
        builder.append(", queuedBytes=");
        builder.append(this.queuedBytes);
        builder.append(", outputCount=");
        builder.append(this.outputCount);
        builder.append(", outputBytes=");
        builder.append(this.outputBytes);
        builder.append(", maxQueuedCount=");
        builder.append(this.maxQueuedCount);
        builder.append(", maxQueueBytes=");
        builder.append(this.maxQueuedBytes);
        builder.append(", totalActiveQueuedDuration=");
        builder.append(this.totalQueuedDuration);
        builder.append(", maxActiveQueuedDuration=");
        builder.append(this.maxQueuedDuration);
        builder.append("]");
        return builder.toString();
    }
}

