/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.encryptor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.encryptor.FlowEncryptor;

public class StandardFlowEncryptor
implements FlowEncryptor {
    private static final Pattern ENCRYPTED_PATTERN = Pattern.compile("enc\\{([^\\}]+?)\\}");
    private static final int FIRST_GROUP = 1;
    private static final String ENCRYPTED_FORMAT = "enc{%s}";

    @Override
    public void processFlow(InputStream inputStream, OutputStream outputStream, PropertyEncryptor inputEncryptor, PropertyEncryptor outputEncryptor) {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            reader.lines().forEach(line -> {
                String outputLine;
                Matcher matcher = ENCRYPTED_PATTERN.matcher((CharSequence)line);
                StringBuffer sb = new StringBuffer();
                boolean matched = false;
                while (matcher.find()) {
                    String outputEncrypted = this.getOutputEncrypted(matcher.group(1), inputEncryptor, outputEncryptor);
                    matcher.appendReplacement(sb, outputEncrypted);
                    matched = true;
                }
                if (matched) {
                    matcher.appendTail(sb);
                    outputLine = sb.toString();
                } else {
                    outputLine = line;
                }
                writer.println(outputLine);
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed Processing Flow Configuration", e);
        }
    }

    private String getOutputEncrypted(String inputEncrypted, PropertyEncryptor inputEncryptor, PropertyEncryptor outputEncryptor) {
        String inputDecrypted = inputEncryptor.decrypt(inputEncrypted);
        String outputEncrypted = outputEncryptor.encrypt(inputDecrypted);
        return String.format(ENCRYPTED_FORMAT, outputEncrypted);
    }
}

