/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.jaxb.message;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.nifi.cluster.protocol.ConnectionResponse;
import org.apache.nifi.cluster.protocol.jaxb.message.AdaptedConnectionResponse;

public class ConnectionResponseAdapter
extends XmlAdapter<AdaptedConnectionResponse, ConnectionResponse> {
    public AdaptedConnectionResponse marshal(ConnectionResponse cr) {
        AdaptedConnectionResponse aCr = new AdaptedConnectionResponse();
        if (cr != null) {
            aCr.setDataFlow(cr.getDataFlow());
            aCr.setNodeIdentifier(cr.getNodeIdentifier());
            aCr.setTryLaterSeconds(cr.getTryLaterSeconds());
            aCr.setBlockedByFirewall(cr.isBlockedByFirewall());
            aCr.setPrimary(cr.isPrimary());
            aCr.setManagerRemoteInputPort(cr.getManagerRemoteInputPort());
            aCr.setManagerRemoteCommsSecure(cr.isManagerRemoteCommsSecure());
            aCr.setInstanceId(cr.getInstanceId());
        }
        return aCr;
    }

    public ConnectionResponse unmarshal(AdaptedConnectionResponse aCr) {
        if (aCr.shouldTryLater()) {
            return new ConnectionResponse(aCr.getTryLaterSeconds());
        }
        if (aCr.isBlockedByFirewall()) {
            return ConnectionResponse.createBlockedByFirewallResponse();
        }
        return new ConnectionResponse(aCr.getNodeIdentifier(), aCr.getDataFlow(), aCr.isPrimary(), aCr.getManagerRemoteInputPort(), aCr.isManagerRemoteCommsSecure(), aCr.getInstanceId());
    }
}

