/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.mvstore.db;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.org.h2.command.ddl.CreateTableData;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.engine.SysProperties;
import org.apache.nifi.org.h2.index.BaseIndex;
import org.apache.nifi.org.h2.index.Cursor;
import org.apache.nifi.org.h2.index.Index;
import org.apache.nifi.org.h2.index.IndexType;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.message.Trace;
import org.apache.nifi.org.h2.mvstore.DataUtils;
import org.apache.nifi.org.h2.mvstore.db.MVDelegateIndex;
import org.apache.nifi.org.h2.mvstore.db.MVIndex;
import org.apache.nifi.org.h2.mvstore.db.MVPrimaryIndex;
import org.apache.nifi.org.h2.mvstore.db.MVSecondaryIndex;
import org.apache.nifi.org.h2.mvstore.db.MVSpatialIndex;
import org.apache.nifi.org.h2.mvstore.db.MVTableEngine;
import org.apache.nifi.org.h2.mvstore.tx.Transaction;
import org.apache.nifi.org.h2.mvstore.tx.TransactionStore;
import org.apache.nifi.org.h2.result.Row;
import org.apache.nifi.org.h2.schema.SchemaObject;
import org.apache.nifi.org.h2.table.Column;
import org.apache.nifi.org.h2.table.IndexColumn;
import org.apache.nifi.org.h2.table.RegularTable;
import org.apache.nifi.org.h2.util.DebuggingThreadLocal;
import org.apache.nifi.org.h2.util.MathUtils;
import org.apache.nifi.org.h2.util.Utils;

public class MVTable
extends RegularTable {
    public static final DebuggingThreadLocal<String> WAITING_FOR_LOCK;
    public static final DebuggingThreadLocal<ArrayList<String>> EXCLUSIVE_LOCKS;
    public static final DebuggingThreadLocal<ArrayList<String>> SHARED_LOCKS;
    private static final String NO_EXTRA_INFO = "";
    private MVPrimaryIndex primaryIndex;
    private final ArrayList<Index> indexes = Utils.newSmallArrayList();
    private final AtomicLong lastModificationId = new AtomicLong();
    private final ArrayDeque<Session> waitingSessions = new ArrayDeque();
    private final Trace traceLock;
    private final AtomicInteger changesUntilAnalyze;
    private int nextAnalyze;
    private final MVTableEngine.Store store;
    private final TransactionStore transactionStore;

    public MVTable(CreateTableData createTableData, MVTableEngine.Store store) {
        super(createTableData);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        this.changesUntilAnalyze = this.nextAnalyze <= 0 ? null : new AtomicInteger(this.nextAnalyze);
        this.store = store;
        this.transactionStore = store.getTransactionStore();
        this.traceLock = this.database.getTrace(7);
        this.primaryIndex = new MVPrimaryIndex(this.database, this, this.getId(), IndexColumn.wrap(this.getColumns()), IndexType.createScan(true));
        this.indexes.add(this.primaryIndex);
    }

    public String getMapName() {
        return this.primaryIndex.getMapName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        int n = this.database.getLockMode();
        if (n == 0) {
            session.registerTableAsUpdated(this);
            return false;
        }
        if (!bl2) {
            if (bl) {
                bl = false;
            } else if (this.lockExclusiveSession == null) {
                return false;
            }
        }
        if (this.lockExclusiveSession == session) {
            return true;
        }
        if (!bl && this.lockSharedSessions.containsKey(session)) {
            return true;
        }
        MVTable mVTable = this;
        synchronized (mVTable) {
            if (!bl && this.lockSharedSessions.containsKey(session)) {
                return true;
            }
            session.setWaitForLock(this, Thread.currentThread());
            if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                WAITING_FOR_LOCK.set(this.getName());
            }
            this.waitingSessions.addLast(session);
            try {
                this.doLock1(session, n, bl);
            }
            finally {
                session.setWaitForLock(null, null);
                if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                    WAITING_FOR_LOCK.remove();
                }
                this.waitingSessions.remove(session);
            }
        }
        return false;
    }

    private void doLock1(Session session, int n, boolean bl) {
        this.traceLock(session, bl, TraceLockEvent.TRACE_LOCK_REQUESTING_FOR, NO_EXTRA_INFO);
        long l = 0L;
        boolean bl2 = false;
        while (this.waitingSessions.getFirst() != session || !this.doLock2(session, n, bl)) {
            if (bl2) {
                ArrayList<Session> arrayList = this.checkDeadlock(session, null, null);
                if (arrayList != null) {
                    throw DbException.get(40001, MVTable.getDeadlockDetails(arrayList, bl));
                }
            } else {
                bl2 = true;
            }
            long l2 = System.nanoTime();
            if (l == 0L) {
                l = l2 + TimeUnit.MILLISECONDS.toNanos(session.getLockTimeout());
            } else if (l2 >= l) {
                this.traceLock(session, bl, TraceLockEvent.TRACE_LOCK_TIMEOUT_AFTER, NO_EXTRA_INFO + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long l3;
                this.traceLock(session, bl, TraceLockEvent.TRACE_LOCK_WAITING_FOR, NO_EXTRA_INFO);
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long l4 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l5 = Runtime.getRuntime().freeMemory();
                        if (l4 == l5) break;
                    }
                }
                if ((l3 = Math.min(100L, TimeUnit.NANOSECONDS.toMillis(l - l2))) == 0L) {
                    l3 = 1L;
                }
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private boolean doLock2(Session session, int n, boolean bl) {
        if (this.lockExclusiveSession == null) {
            if (bl) {
                if (this.lockSharedSessions.isEmpty()) {
                    this.traceLock(session, bl, TraceLockEvent.TRACE_LOCK_ADDED_FOR, NO_EXTRA_INFO);
                    session.registerTableAsLocked(this);
                    this.lockExclusiveSession = session;
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        if (EXCLUSIVE_LOCKS.get() == null) {
                            EXCLUSIVE_LOCKS.set(new ArrayList());
                        }
                        EXCLUSIVE_LOCKS.get().add(this.getName());
                    }
                    return true;
                }
                if (this.lockSharedSessions.size() == 1 && this.lockSharedSessions.containsKey(session)) {
                    this.traceLock(session, bl, TraceLockEvent.TRACE_LOCK_ADD_UPGRADED_FOR, NO_EXTRA_INFO);
                    this.lockExclusiveSession = session;
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        if (EXCLUSIVE_LOCKS.get() == null) {
                            EXCLUSIVE_LOCKS.set(new ArrayList());
                        }
                        EXCLUSIVE_LOCKS.get().add(this.getName());
                    }
                    return true;
                }
            } else {
                if (this.lockSharedSessions.putIfAbsent(session, session) == null) {
                    this.traceLock(session, bl, TraceLockEvent.TRACE_LOCK_OK, NO_EXTRA_INFO);
                    session.registerTableAsLocked(this);
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        ArrayList<String> arrayList = SHARED_LOCKS.get();
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            SHARED_LOCKS.set(arrayList);
                        }
                        arrayList.add(this.getName());
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void traceLock(Session session, boolean bl, TraceLockEvent traceLockEvent, String string) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3} {4}", session.getId(), bl ? "exclusive write lock" : "shared read lock", traceLockEvent.getEventText(), this.getName(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session session) {
        if (this.database != null) {
            boolean bl = this.lockExclusiveSession == session;
            this.traceLock(session, bl, TraceLockEvent.TRACE_LOCK_UNLOCK, NO_EXTRA_INFO);
            if (bl) {
                this.lockSharedSessions.remove(session);
                this.lockExclusiveSession = null;
                if (SysProperties.THREAD_DEADLOCK_DETECTOR && EXCLUSIVE_LOCKS.get() != null) {
                    EXCLUSIVE_LOCKS.get().remove(this.getName());
                }
            } else {
                boolean bl2 = bl = this.lockSharedSessions.remove(session) != null;
                if (SysProperties.THREAD_DEADLOCK_DETECTOR && SHARED_LOCKS.get() != null) {
                    SHARED_LOCKS.get().remove(this.getName());
                }
            }
            if (bl && !this.waitingSessions.isEmpty()) {
                MVTable mVTable = this;
                synchronized (mVTable) {
                    this.notifyAll();
                }
            }
        }
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.primaryIndex.getRow(session, l);
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        BaseIndex baseIndex;
        boolean bl2;
        int n2;
        if (indexType.isPrimaryKey()) {
            IndexColumn[] indexColumnArray2 = indexColumnArray;
            int n3 = indexColumnArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                IndexColumn indexColumn = indexColumnArray2[n2];
                Column column = indexColumn.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl3 = bl2 = this.isTemporary() && !this.isGlobalTemporary();
        if (!bl2) {
            this.database.lockMeta(session);
        }
        int n4 = n2 = this.primaryIndex.getMainIndexColumn() != -1 ? -1 : MVTable.getMainIndexColumn(indexType, indexColumnArray);
        if (this.database.isStarting()) {
            if (this.transactionStore.hasMap("index." + n)) {
                n2 = -1;
            }
        } else if (this.primaryIndex.getRowCountMax() != 0L) {
            n2 = -1;
        }
        if (n2 != -1) {
            this.primaryIndex.setMainIndexColumn(n2);
            baseIndex = new MVDelegateIndex(this, n, string, this.primaryIndex, indexType);
        } else {
            baseIndex = indexType.isSpatial() ? new MVSpatialIndex(session.getDatabase(), this, n, string, indexColumnArray, indexType) : new MVSecondaryIndex(session.getDatabase(), this, n, string, indexColumnArray, indexType);
        }
        if (baseIndex.needRebuild()) {
            this.rebuildIndex(session, (MVIndex)((Object)baseIndex), string);
        }
        baseIndex.setTemporary(this.isTemporary());
        if (baseIndex.getCreateSQL() != null) {
            baseIndex.setComment(string2);
            if (bl2) {
                session.addLocalTempTableIndex(baseIndex);
            } else {
                this.database.addSchemaObject(session, baseIndex);
            }
        }
        this.indexes.add(baseIndex);
        this.setModified();
        return baseIndex;
    }

    private void rebuildIndex(Session session, MVIndex mVIndex, String string) {
        try {
            if (session.getDatabase().getStore() == null || mVIndex instanceof MVSpatialIndex) {
                this.rebuildIndexBuffered(session, mVIndex);
            } else {
                this.rebuildIndexBlockMerge(session, mVIndex);
            }
        }
        catch (DbException dbException) {
            this.getSchema().freeUniqueName(string);
            try {
                mVIndex.remove(session);
            }
            catch (DbException dbException2) {
                this.trace.error(dbException2, "could not remove index");
                throw dbException2;
            }
            throw dbException;
        }
    }

    private void rebuildIndexBlockMerge(Session session, MVIndex mVIndex) {
        Object object;
        long l;
        if (mVIndex instanceof MVSpatialIndex) {
            this.rebuildIndexBuffered(session, mVIndex);
        }
        Index index = this.getScanIndex(session);
        long l2 = l = index.getRowCount(session);
        Cursor cursor = index.find(session, null, null);
        long l3 = 0L;
        MVTableEngine.Store store = session.getDatabase().getStore();
        int n = this.database.getMaxMemoryRows() / 2;
        ArrayList<Row> arrayList = new ArrayList<Row>(n);
        String string = this.getName() + ":" + mVIndex.getName();
        int n2 = MathUtils.convertLongToInt(l2);
        ArrayList<String> arrayList2 = Utils.newSmallArrayList();
        while (cursor.next()) {
            object = cursor.get();
            arrayList.add((Row)object);
            this.database.setProgress(1, string, MathUtils.convertLongToInt(l3++), n2);
            if (arrayList.size() >= n) {
                MVTable.sortRows(arrayList, mVIndex);
                String string2 = store.nextTemporaryMapName();
                mVIndex.addRowsToBuffer(arrayList, string2);
                arrayList2.add(string2);
                arrayList.clear();
            }
            --l;
        }
        MVTable.sortRows(arrayList, mVIndex);
        if (!arrayList2.isEmpty()) {
            object = store.nextTemporaryMapName();
            mVIndex.addRowsToBuffer(arrayList, (String)object);
            arrayList2.add((String)object);
            arrayList.clear();
            mVIndex.addBufferedRows(arrayList2);
        } else {
            MVTable.addRowsToIndex(session, arrayList, mVIndex);
        }
        if (l != 0L) {
            DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
        }
    }

    private void rebuildIndexBuffered(Session session, Index index) {
        long l;
        Index index2 = this.getScanIndex(session);
        long l2 = l = index2.getRowCount(session);
        Cursor cursor = index2.find(session, null, null);
        long l3 = 0L;
        int n = (int)Math.min(l2, (long)this.database.getMaxMemoryRows());
        ArrayList<Row> arrayList = new ArrayList<Row>(n);
        String string = this.getName() + ":" + index.getName();
        int n2 = MathUtils.convertLongToInt(l2);
        while (cursor.next()) {
            Row row = cursor.get();
            arrayList.add(row);
            this.database.setProgress(1, string, MathUtils.convertLongToInt(l3++), n2);
            if (arrayList.size() >= n) {
                MVTable.addRowsToIndex(session, arrayList, index);
            }
            --l;
        }
        MVTable.addRowsToIndex(session, arrayList, index);
        if (l != 0L) {
            DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
        }
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.syncLastModificationIdWithDatabase();
        Transaction transaction = session.getTransaction();
        long l = transaction.setSavepoint();
        try {
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                Index index = this.indexes.get(i);
                index.remove(session, row);
            }
        }
        catch (Throwable throwable) {
            try {
                transaction.rollbackToSavepoint(l);
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void truncate(Session session) {
        this.syncLastModificationIdWithDatabase();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session);
        }
        if (this.changesUntilAnalyze != null) {
            this.changesUntilAnalyze.set(this.nextAnalyze);
        }
    }

    @Override
    public void addRow(Session session, Row row) {
        this.syncLastModificationIdWithDatabase();
        Transaction transaction = session.getTransaction();
        long l = transaction.setSavepoint();
        try {
            for (Index index : this.indexes) {
                index.add(session, row);
            }
        }
        catch (Throwable throwable) {
            try {
                transaction.rollbackToSavepoint(l);
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void updateRow(Session session, Row row, Row row2) {
        row2.setKey(row.getKey());
        this.syncLastModificationIdWithDatabase();
        Transaction transaction = session.getTransaction();
        long l = transaction.setSavepoint();
        try {
            for (Index index : this.indexes) {
                index.update(session, row, row2);
            }
        }
        catch (Throwable throwable) {
            try {
                transaction.rollbackToSavepoint(l);
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public Row lockRow(Session session, Row row) {
        Row row2 = this.primaryIndex.lockRow(session, row);
        if (row2 == null || !row.hasSharedData(row2)) {
            this.syncLastModificationIdWithDatabase();
        }
        return row2;
    }

    private void analyzeIfRequired(Session session) {
        if (this.changesUntilAnalyze != null && this.changesUntilAnalyze.decrementAndGet() == 0) {
            if (this.nextAnalyze <= 0x3FFFFFFF) {
                this.nextAnalyze *= 2;
            }
            this.changesUntilAnalyze.set(this.nextAnalyze);
            session.markTableForAnalyze(this);
        }
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.primaryIndex;
    }

    @Override
    public Index getUniqueIndex() {
        return this.primaryIndex;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId.get();
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.containsLargeObject) {
            this.truncate(session);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session);
        }
        this.database.getStore().removeTable(this);
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            index.remove(session);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session, index);
            }
            this.indexes.remove(index);
        }
        this.primaryIndex.remove(session);
        this.indexes.clear();
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.close(session);
        this.invalidate();
    }

    @Override
    public long getRowCount(Session session) {
        return this.primaryIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.primaryIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.primaryIndex.getDiskSpaceUsed();
    }

    Transaction getTransactionBegin() {
        return this.transactionStore.begin();
    }

    @Override
    public boolean isMVStore() {
        return true;
    }

    public void commit() {
        if (this.database != null) {
            this.syncLastModificationIdWithDatabase();
        }
    }

    private void syncLastModificationIdWithDatabase() {
        long l;
        long l2 = this.database.getNextModificationDataId();
        while (l2 > (l = this.lastModificationId.get()) && !this.lastModificationId.compareAndSet(l, l2)) {
        }
    }

    DbException convertException(IllegalStateException illegalStateException) {
        int n = DataUtils.getErrorCode(illegalStateException.getMessage());
        if (n == 101) {
            throw DbException.get(90131, illegalStateException, this.getName());
        }
        if (n == 105) {
            throw DbException.get(40001, illegalStateException, this.getName());
        }
        return this.store.convertIllegalStateException(illegalStateException);
    }

    static {
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            WAITING_FOR_LOCK = new DebuggingThreadLocal();
            EXCLUSIVE_LOCKS = new DebuggingThreadLocal();
            SHARED_LOCKS = new DebuggingThreadLocal();
        } else {
            WAITING_FOR_LOCK = null;
            EXCLUSIVE_LOCKS = null;
            SHARED_LOCKS = null;
        }
    }

    private static enum TraceLockEvent {
        TRACE_LOCK_OK("ok"),
        TRACE_LOCK_WAITING_FOR("waiting for"),
        TRACE_LOCK_REQUESTING_FOR("requesting for"),
        TRACE_LOCK_TIMEOUT_AFTER("timeout after "),
        TRACE_LOCK_UNLOCK("unlock"),
        TRACE_LOCK_ADDED_FOR("added for"),
        TRACE_LOCK_ADD_UPGRADED_FOR("add (upgraded) for ");

        private final String eventText;

        private TraceLockEvent(String string2) {
            this.eventText = string2;
        }

        public String getEventText() {
            return this.eventText;
        }
    }
}

