/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.table;

import java.util.Objects;
import org.apache.nifi.org.h2.command.Parser;
import org.apache.nifi.org.h2.command.ddl.SequenceOptions;
import org.apache.nifi.org.h2.engine.DbObjectBase;
import org.apache.nifi.org.h2.engine.Domain;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.expression.Expression;
import org.apache.nifi.org.h2.expression.ExpressionVisitor;
import org.apache.nifi.org.h2.expression.SequenceValue;
import org.apache.nifi.org.h2.expression.ValueExpression;
import org.apache.nifi.org.h2.expression.condition.ConditionAndOr;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.result.Row;
import org.apache.nifi.org.h2.schema.Schema;
import org.apache.nifi.org.h2.schema.SchemaObject;
import org.apache.nifi.org.h2.schema.Sequence;
import org.apache.nifi.org.h2.table.SingleColumnResolver;
import org.apache.nifi.org.h2.table.Table;
import org.apache.nifi.org.h2.table.TableFilter;
import org.apache.nifi.org.h2.util.MathUtils;
import org.apache.nifi.org.h2.util.StringUtils;
import org.apache.nifi.org.h2.value.DataType;
import org.apache.nifi.org.h2.value.TypeInfo;
import org.apache.nifi.org.h2.value.Value;
import org.apache.nifi.org.h2.value.ValueLong;
import org.apache.nifi.org.h2.value.ValueNull;
import org.apache.nifi.org.h2.value.ValueUuid;

public class Column {
    public static final String ROWID = "_ROWID_";
    public static final int NOT_NULLABLE = 0;
    public static final int NULLABLE = 1;
    public static final int NULLABLE_UNKNOWN = 2;
    private final TypeInfo type;
    private Table table;
    private String name;
    private int columnId;
    private boolean nullable = true;
    private Expression defaultExpression;
    private Expression onUpdateExpression;
    private Expression checkConstraint;
    private String checkConstraintSQL;
    private String originalSQL;
    private SequenceOptions autoIncrementOptions;
    private boolean convertNullToDefault;
    private Sequence sequence;
    private boolean isComputed;
    private TableFilter computeTableFilter;
    private int selectivity;
    private SingleColumnResolver resolver;
    private String comment;
    private boolean primaryKey;
    private boolean visible = true;
    private boolean rowId;
    private Domain domain;

    public static StringBuilder writeColumns(StringBuilder stringBuilder, Column[] columnArray, boolean bl) {
        int n = columnArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            columnArray[i].getSQL(stringBuilder, bl);
        }
        return stringBuilder;
    }

    public static StringBuilder writeColumns(StringBuilder stringBuilder, Column[] columnArray, String string, String string2, boolean bl) {
        int n = columnArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            columnArray[i].getSQL(stringBuilder, bl).append(string2);
        }
        return stringBuilder;
    }

    public Column(String string, int n) {
        this(string, TypeInfo.getTypeInfo(n));
    }

    public Column(String string, TypeInfo typeInfo) {
        this.name = string;
        this.type = typeInfo;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Column)) {
            return false;
        }
        Column column = (Column)object;
        if (this.table == null || column.table == null || this.name == null || column.name == null) {
            return false;
        }
        if (this.table != column.table) {
            return false;
        }
        return this.name.equals(column.name);
    }

    public int hashCode() {
        if (this.table == null || this.name == null) {
            return 0;
        }
        return this.table.getId() ^ this.name.hashCode();
    }

    public Column getClone() {
        Column column = new Column(this.name, this.type);
        column.copy(this);
        return column;
    }

    public Value convert(Value value, boolean bl) {
        try {
            return value.convertTo(this.type, this.table.getDatabase(), bl, this);
        }
        catch (DbException dbException) {
            DbException dbException2;
            if (dbException.getErrorCode() == 22018) {
                dbException2 = this.getDataConversionError(value, dbException);
            }
            throw dbException2;
        }
    }

    boolean getComputed() {
        return this.isComputed;
    }

    synchronized Value computeValue(Session session, Row row) {
        this.computeTableFilter.setSession(session);
        this.computeTableFilter.set(row);
        return this.defaultExpression.getValue(session);
    }

    public void setComputedExpression(Expression expression) {
        this.isComputed = true;
        this.defaultExpression = expression;
    }

    public void setTable(Table table, int n) {
        this.table = table;
        this.columnId = n;
    }

    public Table getTable() {
        return this.table;
    }

    public void setDefaultExpression(Session session, Expression expression) {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.defaultExpression = expression;
    }

    public void setOnUpdateExpression(Session session, Expression expression) {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.onUpdateExpression = expression;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public String getSQL(boolean bl) {
        return this.rowId ? this.name : Parser.quoteIdentifier(this.name, bl);
    }

    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return this.rowId ? stringBuilder.append(this.name) : Parser.quoteIdentifier(stringBuilder, this.name, bl);
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public boolean isRowId() {
        return this.rowId;
    }

    public void setRowId(boolean bl) {
        this.rowId = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value validateConvertUpdateSequence(Session session, Value value) {
        Expression expression;
        Column column = this;
        synchronized (column) {
            expression = this.defaultExpression;
        }
        boolean bl = false;
        if (value == null) {
            if (expression == null) {
                value = ValueNull.INSTANCE;
            } else {
                value = expression.getValue(session);
                bl = true;
            }
        }
        if (value == ValueNull.INSTANCE) {
            if (this.convertNullToDefault) {
                value = expression.getValue(session);
                bl = true;
            }
            if (value == ValueNull.INSTANCE && !this.nullable) {
                throw DbException.get(23502, this.name);
            }
        }
        try {
            value = this.type.cast(value, session, false, false, this.name);
        }
        catch (DbException dbException) {
            DbException dbException2;
            if (dbException.getErrorCode() == 22018) {
                dbException2 = this.getDataConversionError(value, dbException);
            }
            throw dbException2;
        }
        if (this.checkConstraint != null) {
            Value value2;
            Column column2 = this;
            synchronized (column2) {
                this.resolver.setValue(value);
                value2 = this.checkConstraint.getValue(session);
            }
            if (value2 != ValueNull.INSTANCE && !value2.getBoolean()) {
                throw DbException.get(23513, this.checkConstraint.getSQL(false));
            }
        }
        if (bl && !expression.isConstant() && this.primaryKey) {
            session.setLastIdentity(value);
        }
        this.updateSequenceIfRequired(session, value);
        return value;
    }

    private DbException getDataConversionError(Value value, DbException dbException) {
        StringBuilder stringBuilder = new StringBuilder().append(value.getTraceSQL()).append(" (");
        if (this.table != null) {
            stringBuilder.append(this.table.getName()).append(": ");
        }
        stringBuilder.append(this.getCreateSQL()).append(')');
        return DbException.get(22018, dbException, stringBuilder.toString());
    }

    private void updateSequenceIfRequired(Session session, Value value) {
        if (this.sequence != null) {
            long l = this.sequence.getCurrentValue();
            long l2 = this.sequence.getIncrement();
            long l3 = value.getLong();
            boolean bl = false;
            if (l2 > 0L && l3 > l) {
                bl = true;
            } else if (l2 < 0L && l3 < l) {
                bl = true;
            }
            if (bl) {
                this.sequence.modify(l3 + l2, null, null, null);
                session.setLastIdentity(ValueLong.get(l3));
                this.sequence.flush(session);
            }
        }
    }

    public void convertAutoIncrementToSequence(Session session, Schema schema, int n, boolean bl) {
        Object object;
        Object object2;
        String string;
        if (this.autoIncrementOptions == null) {
            DbException.throwInternalError();
        }
        if ("IDENTITY".equals(this.originalSQL)) {
            this.originalSQL = "BIGINT";
        } else if ("SERIAL".equals(this.originalSQL)) {
            this.originalSQL = "INT";
        }
        do {
            object = ValueUuid.getNewRandom();
            object2 = ((ValueUuid)object).getString();
            object2 = StringUtils.toUpperEnglish(((String)object2).replace('-', '_'));
        } while (schema.findSequence(string = "SYSTEM_SEQUENCE_" + (String)object2) != null);
        object = new Sequence(session, schema, n, string, this.autoIncrementOptions, true);
        ((DbObjectBase)object).setTemporary(bl);
        session.getDatabase().addSchemaObject(session, (SchemaObject)object);
        this.setAutoIncrementOptions(null);
        object2 = new SequenceValue((Sequence)object, false);
        this.setDefaultExpression(session, (Expression)object2);
        this.setSequence((Sequence)object);
    }

    public void prepareExpression(Session session) {
        if (this.defaultExpression != null || this.onUpdateExpression != null) {
            this.computeTableFilter = new TableFilter(session, this.table, null, false, null, 0, null);
            if (this.defaultExpression != null) {
                this.defaultExpression.mapColumns(this.computeTableFilter, 0, 0);
                this.defaultExpression = this.defaultExpression.optimize(session);
            }
            if (this.onUpdateExpression != null) {
                this.onUpdateExpression.mapColumns(this.computeTableFilter, 0, 0);
                this.onUpdateExpression = this.onUpdateExpression.optimize(session);
            }
        }
    }

    public String getCreateSQLWithoutName() {
        return this.getCreateSQL(false);
    }

    public String getCreateSQL() {
        return this.getCreateSQL(true);
    }

    private String getCreateSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl && this.name != null) {
            Parser.quoteIdentifier(stringBuilder, this.name, true).append(' ');
        }
        if (this.originalSQL != null) {
            stringBuilder.append(this.originalSQL);
        } else {
            this.type.getSQL(stringBuilder);
        }
        if (!this.visible) {
            stringBuilder.append(" INVISIBLE ");
        }
        if (this.defaultExpression != null) {
            if (this.isComputed) {
                stringBuilder.append(" AS ");
                this.defaultExpression.getSQL(stringBuilder, true);
            } else if (this.defaultExpression != null) {
                stringBuilder.append(" DEFAULT ");
                this.defaultExpression.getSQL(stringBuilder, true);
            }
        }
        if (this.onUpdateExpression != null) {
            stringBuilder.append(" ON UPDATE ");
            this.onUpdateExpression.getSQL(stringBuilder, true);
        }
        if (!this.nullable) {
            stringBuilder.append(" NOT NULL");
        } else if (this.domain != null && !this.domain.getColumn().isNullable()) {
            stringBuilder.append(" NULL");
        }
        if (this.convertNullToDefault) {
            stringBuilder.append(" NULL_TO_DEFAULT");
        }
        if (this.sequence != null) {
            stringBuilder.append(" SEQUENCE ");
            this.sequence.getSQL(stringBuilder, true);
        }
        if (this.selectivity != 0) {
            stringBuilder.append(" SELECTIVITY ").append(this.selectivity);
        }
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        if (this.checkConstraint != null) {
            stringBuilder.append(" CHECK ").append(this.checkConstraintSQL);
        }
        return stringBuilder.toString();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setOriginalSQL(String string) {
        this.originalSQL = string;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public Expression getOnUpdateExpression() {
        return this.onUpdateExpression;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrementOptions != null;
    }

    public void setAutoIncrementOptions(SequenceOptions sequenceOptions) {
        this.autoIncrementOptions = sequenceOptions;
        this.nullable = false;
        if (sequenceOptions != null) {
            this.convertNullToDefault = true;
        }
    }

    public SequenceOptions getAutoIncrementOptions() {
        return this.autoIncrementOptions;
    }

    public void setConvertNullToDefault(boolean bl) {
        this.convertNullToDefault = bl;
    }

    public void rename(String string) {
        this.name = string;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int getSelectivity() {
        return this.selectivity == 0 ? 50 : this.selectivity;
    }

    public void setSelectivity(int n) {
        this.selectivity = n = n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckConstraint(Session session, Expression expression) {
        if (expression == null) {
            return;
        }
        if (this.resolver == null) {
            this.resolver = new SingleColumnResolver(session.getDatabase(), this);
        }
        Column column = this;
        synchronized (column) {
            String string = this.name;
            if (this.name == null) {
                this.name = "VALUE";
            }
            expression.mapColumns(this.resolver, 0, 0);
            this.name = string;
        }
        expression = expression.optimize(session);
        this.resolver.setValue(ValueNull.INSTANCE);
        column = this;
        synchronized (column) {
            expression.getValue(session);
        }
        if (this.checkConstraint == null) {
            this.checkConstraint = expression;
        } else if (!expression.getSQL(true).equals(this.checkConstraintSQL)) {
            this.checkConstraint = new ConditionAndOr(0, this.checkConstraint, expression);
        }
        this.checkConstraintSQL = this.getCheckConstraintSQL(session, this.name);
    }

    public void removeCheckConstraint() {
        this.checkConstraint = null;
        this.checkConstraintSQL = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCheckConstraint(Session session, String string) {
        String string2;
        if (this.checkConstraint == null) {
            return null;
        }
        Parser parser = new Parser(session);
        Column column = this;
        synchronized (column) {
            String string3 = this.name;
            this.name = string;
            string2 = this.checkConstraint.getSQL(true);
            this.name = string3;
        }
        return parser.parseExpression(string2);
    }

    String getDefaultSQL() {
        return this.defaultExpression == null ? null : this.defaultExpression.getSQL(true);
    }

    String getOnUpdateSQL() {
        return this.onUpdateExpression == null ? null : this.onUpdateExpression.getSQL(true);
    }

    int getPrecisionAsInt() {
        return MathUtils.convertLongToInt(this.type.getPrecision());
    }

    DataType getDataType() {
        return DataType.getDataType(this.type.getValueType());
    }

    String getCheckConstraintSQL(Session session, String string) {
        Expression expression = this.getCheckConstraint(session, string);
        return expression == null ? "" : expression.getSQL(true);
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPrimaryKey(boolean bl) {
        this.primaryKey = bl;
    }

    boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 7 && this.sequence != null) {
            expressionVisitor.getDependencies().add(this.sequence);
        }
        if (this.defaultExpression != null && !this.defaultExpression.isEverything(expressionVisitor)) {
            return false;
        }
        if (this.onUpdateExpression != null && !this.onUpdateExpression.isEverything(expressionVisitor)) {
            return false;
        }
        return this.checkConstraint == null || this.checkConstraint.isEverything(expressionVisitor);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String toString() {
        return this.name;
    }

    public boolean isWideningConversion(Column column) {
        if (this.type != column.type) {
            return false;
        }
        if (this.type.getPrecision() > column.type.getPrecision()) {
            return false;
        }
        if (this.type.getScale() != column.type.getScale()) {
            return false;
        }
        if (this.nullable && !column.nullable) {
            return false;
        }
        if (this.convertNullToDefault != column.convertNullToDefault) {
            return false;
        }
        if (this.primaryKey != column.primaryKey) {
            return false;
        }
        if (this.autoIncrementOptions != null || column.autoIncrementOptions != null) {
            return false;
        }
        if (this.checkConstraint != null || column.checkConstraint != null) {
            return false;
        }
        if (this.convertNullToDefault || column.convertNullToDefault) {
            return false;
        }
        if (this.defaultExpression != null || column.defaultExpression != null) {
            return false;
        }
        if (this.isComputed || column.isComputed) {
            return false;
        }
        if (this.onUpdateExpression != null || column.onUpdateExpression != null) {
            return false;
        }
        return Objects.equals(this.type.getExtTypeInfo(), column.type.getExtTypeInfo());
    }

    public void copy(Column column) {
        this.checkConstraint = column.checkConstraint;
        this.checkConstraintSQL = column.checkConstraintSQL;
        this.name = column.name;
        this.nullable = column.nullable;
        this.defaultExpression = column.defaultExpression;
        this.onUpdateExpression = column.onUpdateExpression;
        this.originalSQL = column.originalSQL;
        this.convertNullToDefault = column.convertNullToDefault;
        this.sequence = column.sequence;
        this.comment = column.comment;
        this.computeTableFilter = column.computeTableFilter;
        this.isComputed = column.isComputed;
        this.selectivity = column.selectivity;
        this.primaryKey = column.primaryKey;
        this.visible = column.visible;
    }
}

