/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.apache.nifi.org.h2.command.CommandInterface;
import org.apache.nifi.org.h2.engine.CastDataProvider;
import org.apache.nifi.org.h2.engine.ConnectionInfo;
import org.apache.nifi.org.h2.engine.IsolationLevel;
import org.apache.nifi.org.h2.engine.Mode;
import org.apache.nifi.org.h2.engine.SessionInterface;
import org.apache.nifi.org.h2.engine.SessionRemote;
import org.apache.nifi.org.h2.engine.SysProperties;
import org.apache.nifi.org.h2.jdbc.JdbcArray;
import org.apache.nifi.org.h2.jdbc.JdbcBlob;
import org.apache.nifi.org.h2.jdbc.JdbcCallableStatement;
import org.apache.nifi.org.h2.jdbc.JdbcClob;
import org.apache.nifi.org.h2.jdbc.JdbcConnectionBackwardsCompat;
import org.apache.nifi.org.h2.jdbc.JdbcDatabaseMetaData;
import org.apache.nifi.org.h2.jdbc.JdbcLob;
import org.apache.nifi.org.h2.jdbc.JdbcPreparedStatement;
import org.apache.nifi.org.h2.jdbc.JdbcResultSet;
import org.apache.nifi.org.h2.jdbc.JdbcSQLXML;
import org.apache.nifi.org.h2.jdbc.JdbcSavepoint;
import org.apache.nifi.org.h2.jdbc.JdbcStatement;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.message.TraceObject;
import org.apache.nifi.org.h2.result.ResultInterface;
import org.apache.nifi.org.h2.util.CloseWatcher;
import org.apache.nifi.org.h2.util.CurrentTimestamp;
import org.apache.nifi.org.h2.util.JdbcUtils;
import org.apache.nifi.org.h2.value.CompareMode;
import org.apache.nifi.org.h2.value.DataType;
import org.apache.nifi.org.h2.value.Value;
import org.apache.nifi.org.h2.value.ValueBytes;
import org.apache.nifi.org.h2.value.ValueInt;
import org.apache.nifi.org.h2.value.ValueNull;
import org.apache.nifi.org.h2.value.ValueResultSet;
import org.apache.nifi.org.h2.value.ValueString;
import org.apache.nifi.org.h2.value.ValueTimestampTimeZone;

public class JdbcConnection
extends TraceObject
implements Connection,
JdbcConnectionBackwardsCompat,
CastDataProvider {
    private static final String NUM_SERVERS = "numServers";
    private static final String PREFIX_SERVER = "server";
    private static boolean keepOpenStackTrace;
    private final String url;
    private final String user;
    private int holdability = 1;
    private SessionInterface session;
    private CommandInterface commit;
    private CommandInterface rollback;
    private CommandInterface getReadOnly;
    private CommandInterface getGeneratedKeys;
    private CommandInterface setQueryTimeout;
    private CommandInterface getQueryTimeout;
    private int savepointId;
    private String catalog;
    private Statement executingStatement;
    private final CloseWatcher watcher;
    private int queryTimeoutCache = -1;
    private Map<String, String> clientInfo;
    private volatile Settings settings;
    private final boolean scopeGeneratedKeys;

    public JdbcConnection(String string, Properties properties) throws SQLException {
        this(new ConnectionInfo(string, properties), true);
    }

    public JdbcConnection(ConnectionInfo connectionInfo, boolean bl) throws SQLException {
        try {
            String string;
            if (bl && (string = SysProperties.getBaseDir()) != null) {
                connectionInfo.setBaseDir(string);
            }
            this.session = new SessionRemote(connectionInfo).connectEmbeddedOrServer(false);
            this.trace = this.session.getTrace();
            int n = JdbcConnection.getNextId(1);
            this.setTrace(this.trace, 1, n);
            this.user = connectionInfo.getUserName();
            if (this.isInfoEnabled()) {
                this.trace.infoCode("Connection " + this.getTraceObjectName() + " = DriverManager.getConnection(" + JdbcConnection.quote(connectionInfo.getOriginalURL()) + ", " + JdbcConnection.quote(this.user) + ", \"\");");
            }
            this.url = connectionInfo.getURL();
            this.scopeGeneratedKeys = connectionInfo.getProperty("SCOPE_GENERATED_KEYS", false);
            this.closeOld();
            this.watcher = CloseWatcher.register(this, this.session, keepOpenStackTrace);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public JdbcConnection(JdbcConnection jdbcConnection) {
        this.session = jdbcConnection.session;
        this.trace = this.session.getTrace();
        int n = JdbcConnection.getNextId(1);
        this.setTrace(this.trace, 1, n);
        this.user = jdbcConnection.user;
        this.url = jdbcConnection.url;
        this.catalog = jdbcConnection.catalog;
        this.commit = jdbcConnection.commit;
        this.getGeneratedKeys = jdbcConnection.getGeneratedKeys;
        this.getQueryTimeout = jdbcConnection.getQueryTimeout;
        this.getReadOnly = jdbcConnection.getReadOnly;
        this.rollback = jdbcConnection.rollback;
        this.scopeGeneratedKeys = jdbcConnection.scopeGeneratedKeys;
        this.watcher = null;
        if (jdbcConnection.clientInfo != null) {
            this.clientInfo = new HashMap<String, String>(jdbcConnection.clientInfo);
        }
    }

    public JdbcConnection(SessionInterface sessionInterface, String string, String string2) {
        this.session = sessionInterface;
        this.trace = sessionInterface.getTrace();
        int n = JdbcConnection.getNextId(1);
        this.setTrace(this.trace, 1, n);
        this.user = string;
        this.url = string2;
        this.scopeGeneratedKeys = false;
        this.watcher = null;
    }

    private void closeOld() {
        CloseWatcher closeWatcher;
        while ((closeWatcher = CloseWatcher.pollUnclosed()) != null) {
            try {
                closeWatcher.getCloseable().close();
            }
            catch (Exception exception) {
                this.trace.error(exception, "closing session");
            }
            keepOpenStackTrace = true;
            String string = closeWatcher.getOpenStackTrace();
            DbException dbException = DbException.get(90018);
            this.trace.error(dbException, string);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n, "createStatement()");
            }
            this.checkClosed();
            return new JdbcStatement(this, n, 1003, 1007, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            int n3 = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n3, "createStatement(" + n + ", " + n2 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            this.checkClosed();
            return new JdbcStatement(this, n3, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            int n4 = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n4, "createStatement(" + n + ", " + n2 + ", " + n3 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            JdbcConnection.checkHoldability(n3);
            this.checkClosed();
            return new JdbcStatement(this, n4, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string) + ")");
            }
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n, 1003, 1007, false, null);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    PreparedStatement prepareAutoCloseStatement(String string) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string) + ")");
            }
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n, 1003, 1007, true, null);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(2);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("DatabaseMetaData", 2, n, "getMetaData()");
            }
            this.checkClosed();
            return new JdbcDatabaseMetaData(this, this.trace, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public SessionInterface getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            if (this.session == null) {
                return;
            }
            CloseWatcher.unregister(this.watcher);
            this.session.cancel();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                block18: {
                    if (this.executingStatement != null) {
                        try {
                            this.executingStatement.cancel();
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.session.isClosed()) break block18;
                        try {
                            block19: {
                                if (this.session.hasPendingTransaction()) {
                                    try {
                                        this.rollbackInternal();
                                    }
                                    catch (DbException dbException) {
                                        if (dbException.getErrorCode() == 90067) break block19;
                                        throw dbException;
                                    }
                                }
                            }
                            this.closePreparedCommands();
                        }
                        finally {
                            this.session.close();
                        }
                    }
                    finally {
                        this.session = null;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    private void closePreparedCommands() {
        this.commit = JdbcConnection.closeAndSetNull(this.commit);
        this.rollback = JdbcConnection.closeAndSetNull(this.rollback);
        this.getReadOnly = JdbcConnection.closeAndSetNull(this.getReadOnly);
        this.getGeneratedKeys = JdbcConnection.closeAndSetNull(this.getGeneratedKeys);
        this.getQueryTimeout = JdbcConnection.closeAndSetNull(this.getQueryTimeout);
        this.setQueryTimeout = JdbcConnection.closeAndSetNull(this.setQueryTimeout);
    }

    private static CommandInterface closeAndSetNull(CommandInterface commandInterface) {
        if (commandInterface != null) {
            commandInterface.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAutoCommit(" + bl + ");");
            }
            this.checkClosed();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                if (bl && !this.session.getAutoCommit()) {
                    this.commit();
                }
                this.session.setAutoCommit(bl);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.checkClosed();
            this.debugCodeCall("getAutoCommit");
            return this.session.getAutoCommit();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        try {
            this.debugCodeCall("commit");
            this.checkClosedForWrite();
            if (SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT && this.getAutoCommit()) {
                throw DbException.get(90147, "commit()");
            }
            this.commit = this.prepareCommand("COMMIT", this.commit);
            this.commit.executeUpdate(null);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        try {
            this.debugCodeCall("rollback");
            this.checkClosedForWrite();
            if (SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT && this.getAutoCommit()) {
                throw DbException.get(90147, "rollback()");
            }
            this.rollbackInternal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.session == null || this.session.isClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        try {
            this.debugCodeCall("nativeSQL", string);
            this.checkClosed();
            return JdbcConnection.translateSQL(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setReadOnly(" + bl + ");");
            }
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.debugCodeCall("isReadOnly");
            this.checkClosed();
            this.getReadOnly = this.prepareCommand("CALL READONLY()", this.getReadOnly);
            ResultInterface resultInterface = this.getReadOnly.executeQuery(0, false);
            resultInterface.next();
            return resultInterface.currentRow()[0].getBoolean();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        try {
            this.debugCodeCall("setCatalog", string);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.debugCodeCall("getCatalog");
            this.checkClosed();
            if (this.catalog == null) {
                CommandInterface commandInterface = this.prepareCommand("CALL DATABASE()", Integer.MAX_VALUE);
                ResultInterface resultInterface = commandInterface.executeQuery(0, false);
                resultInterface.next();
                this.catalog = resultInterface.currentRow()[0].getString();
                commandInterface.close();
            }
            return this.catalog;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            int n3 = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n3, "prepareStatement(" + JdbcConnection.quote(string) + ", " + n + ", " + n2 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n3, n, n2, false, null);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        try {
            this.debugCodeCall("setTransactionIsolation", n);
            this.checkClosed();
            if (!this.getAutoCommit()) {
                this.commit();
            }
            this.session.setIsolationLevel(IsolationLevel.fromJdbc(n));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", n);
            this.checkClosed();
            this.setQueryTimeout = this.prepareCommand("SET QUERY_TIMEOUT ?", this.setQueryTimeout);
            this.setQueryTimeout.getParameters().get(0).setValue(ValueInt.get(n * 1000), false);
            this.setQueryTimeout.executeUpdate(null);
            this.queryTimeoutCache = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    int getQueryTimeout() throws SQLException {
        try {
            if (this.queryTimeoutCache == -1) {
                this.checkClosed();
                this.getQueryTimeout = this.prepareCommand("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?", this.getQueryTimeout);
                this.getQueryTimeout.getParameters().get(0).setValue(ValueString.get("QUERY_TIMEOUT"), false);
                ResultInterface resultInterface = this.getQueryTimeout.executeQuery(0, false);
                resultInterface.next();
                int n = resultInterface.currentRow()[0].getInt();
                resultInterface.close();
                if (n != 0) {
                    n = (n + 999) / 1000;
                }
                this.queryTimeoutCache = n;
            }
            return this.queryTimeoutCache;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            this.debugCodeCall("getTransactionIsolation");
            this.checkClosed();
            return this.session.getIsolationLevel().getJdbc();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        try {
            this.debugCodeCall("setHoldability", n);
            this.checkClosed();
            JdbcConnection.checkHoldability(n);
            this.holdability = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.holdability;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.debugCodeCall("getTypeMap");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTypeMap(" + JdbcConnection.quoteMap(map) + ");");
            }
            JdbcConnection.checkMap(map);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n, "prepareCall(" + JdbcConnection.quote(string) + ")");
            }
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcCallableStatement(this, string, n, 1003, 1007);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            int n3 = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n3, "prepareCall(" + JdbcConnection.quote(string) + ", " + n + ", " + n2 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcCallableStatement(this, string, n3, n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            int n4 = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n4, "prepareCall(" + JdbcConnection.quote(string) + ", " + n + ", " + n2 + ", " + n3 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            JdbcConnection.checkHoldability(n3);
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcCallableStatement(this, string, n4, n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n, "setSavepoint()");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(null, this.savepointId), Integer.MAX_VALUE);
            commandInterface.executeUpdate(null);
            JdbcSavepoint jdbcSavepoint = new JdbcSavepoint(this, this.savepointId, null, this.trace, n);
            ++this.savepointId;
            return jdbcSavepoint;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n, "setSavepoint(" + JdbcConnection.quote(string) + ")");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(string, 0), Integer.MAX_VALUE);
            commandInterface.executeUpdate(null);
            return new JdbcSavepoint(this, 0, string, this.trace, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            JdbcSavepoint jdbcSavepoint = JdbcConnection.convertSavepoint(savepoint);
            if (this.isDebugEnabled()) {
                this.debugCode("rollback(" + jdbcSavepoint.getTraceObjectName() + ");");
            }
            this.checkClosedForWrite();
            jdbcSavepoint.rollback();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.debugCode("releaseSavepoint(savepoint);");
            this.checkClosed();
            JdbcConnection.convertSavepoint(savepoint).release();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private static JdbcSavepoint convertSavepoint(Savepoint savepoint) {
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw DbException.get(90063, String.valueOf(savepoint));
        }
        return (JdbcSavepoint)savepoint;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            int n4 = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n4, "prepareStatement(" + JdbcConnection.quote(string) + ", " + n + ", " + n2 + ", " + n3 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            JdbcConnection.checkHoldability(n3);
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n4, n, n2, false, null);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            int n2 = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n2, "prepareStatement(" + JdbcConnection.quote(string) + ", " + n + ");");
            }
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n2, 1003, 1007, false, n == 1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string) + ", " + JdbcConnection.quoteIntArray(nArray) + ");");
            }
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n, 1003, 1007, false, nArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string) + ", " + JdbcConnection.quoteArray(stringArray) + ");");
            }
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n, 1003, 1007, false, stringArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    CommandInterface prepareCommand(String string, int n) {
        return this.session.prepareCommand(string, n);
    }

    private CommandInterface prepareCommand(String string, CommandInterface commandInterface) {
        return commandInterface == null ? this.session.prepareCommand(string, Integer.MAX_VALUE) : commandInterface;
    }

    private static int translateGetEnd(String string, int n, char c) {
        int n2 = string.length();
        switch (c) {
            case '$': {
                if (n < n2 - 1 && string.charAt(n + 1) == '$' && (n == 0 || string.charAt(n - 1) <= ' ')) {
                    int n3 = string.indexOf("$$", n + 2);
                    if (n3 < 0) {
                        throw DbException.getSyntaxError(string, n);
                    }
                    return n3 + 1;
                }
                return n;
            }
            case '\'': {
                int n4 = string.indexOf(39, n + 1);
                if (n4 < 0) {
                    throw DbException.getSyntaxError(string, n);
                }
                return n4;
            }
            case '\"': {
                int n5 = string.indexOf(34, n + 1);
                if (n5 < 0) {
                    throw DbException.getSyntaxError(string, n);
                }
                return n5;
            }
            case '/': {
                JdbcConnection.checkRunOver(n + 1, n2, string);
                if (string.charAt(n + 1) == '*') {
                    int n6 = string.indexOf("*/", n + 2);
                    if (n6 < 0) {
                        throw DbException.getSyntaxError(string, n);
                    }
                    n = n6 + 1;
                } else if (string.charAt(n + 1) == '/') {
                    n += 2;
                    while (n < n2 && (c = string.charAt(n)) != '\r' && c != '\n') {
                        ++n;
                    }
                }
                return n;
            }
            case '-': {
                JdbcConnection.checkRunOver(n + 1, n2, string);
                if (string.charAt(n + 1) == '-') {
                    n += 2;
                    while (n < n2 && (c = string.charAt(n)) != '\r' && c != '\n') {
                        ++n;
                    }
                }
                return n;
            }
        }
        throw DbException.throwInternalError("c=" + c);
    }

    private static String translateSQL(String string) {
        return JdbcConnection.translateSQL(string, true);
    }

    static String translateSQL(String string, boolean bl) {
        if (string == null) {
            throw DbException.getInvalidValueException("SQL", null);
        }
        if (!bl) {
            return string;
        }
        if (string.indexOf(123) < 0) {
            return string;
        }
        int n = string.length();
        char[] cArray = null;
        int n2 = 0;
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '-': 
                case '/': {
                    i = JdbcConnection.translateGetEnd(string, i, c);
                    continue block9;
                }
                case '{': {
                    ++n2;
                    if (cArray == null) {
                        cArray = string.toCharArray();
                    }
                    cArray[i] = 32;
                    while (Character.isSpaceChar(cArray[i])) {
                        JdbcConnection.checkRunOver(++i, n, string);
                    }
                    int n3 = i;
                    if (cArray[i] >= '0' && cArray[i] <= '9') {
                        cArray[i - 1] = 123;
                        while (true) {
                            JdbcConnection.checkRunOver(i, n, string);
                            c = cArray[i];
                            if (c == '}') break;
                            switch (c) {
                                case '\"': 
                                case '\'': 
                                case '-': 
                                case '/': {
                                    i = JdbcConnection.translateGetEnd(string, i, c);
                                    break;
                                }
                            }
                            ++i;
                        }
                        --n2;
                        continue block9;
                    }
                    if (cArray[i] == '?') {
                        JdbcConnection.checkRunOver(++i, n, string);
                        while (Character.isSpaceChar(cArray[i])) {
                            JdbcConnection.checkRunOver(++i, n, string);
                        }
                        if (string.charAt(i) != '=') {
                            throw DbException.getSyntaxError(string, i, "=");
                        }
                        JdbcConnection.checkRunOver(++i, n, string);
                        while (Character.isSpaceChar(cArray[i])) {
                            JdbcConnection.checkRunOver(++i, n, string);
                        }
                    }
                    while (!Character.isSpaceChar(cArray[i])) {
                        JdbcConnection.checkRunOver(++i, n, string);
                    }
                    int n4 = 0;
                    if (JdbcConnection.found(string, n3, "fn")) {
                        n4 = 2;
                    } else {
                        if (JdbcConnection.found(string, n3, "escape") || JdbcConnection.found(string, n3, "call")) continue block9;
                        if (JdbcConnection.found(string, n3, "oj")) {
                            n4 = 2;
                        } else {
                            if (JdbcConnection.found(string, n3, "ts") || JdbcConnection.found(string, n3, "t") || JdbcConnection.found(string, n3, "d")) continue block9;
                            if (JdbcConnection.found(string, n3, "params")) {
                                n4 = "params".length();
                            }
                        }
                    }
                    i = n3;
                    while (n4 > 0) {
                        cArray[i] = 32;
                        ++i;
                        --n4;
                    }
                    continue block9;
                }
                case '}': {
                    if (--n2 < 0) {
                        throw DbException.getSyntaxError(string, i);
                    }
                    cArray[i] = 32;
                    continue block9;
                }
                case '$': {
                    i = JdbcConnection.translateGetEnd(string, i, c);
                    continue block9;
                }
            }
        }
        if (n2 != 0) {
            throw DbException.getSyntaxError(string, string.length() - 1);
        }
        if (cArray != null) {
            string = new String(cArray);
        }
        return string;
    }

    private static void checkRunOver(int n, int n2, String string) {
        if (n >= n2) {
            throw DbException.getSyntaxError(string, n);
        }
    }

    private static boolean found(String string, int n, String string2) {
        return string.regionMatches(true, n, string2, 0, string2.length());
    }

    private static void checkTypeConcurrency(int n, int n2) {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetType", n);
            }
        }
        switch (n2) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetConcurrency", n2);
            }
        }
    }

    private static void checkHoldability(int n) {
        if (n != 1 && n != 2) {
            throw DbException.getInvalidValueException("resultSetHoldability", n);
        }
    }

    protected void checkClosed() {
        this.checkClosed(false);
    }

    private void checkClosedForWrite() {
        this.checkClosed(true);
    }

    protected void checkClosed(boolean bl) {
        if (this.session == null) {
            throw DbException.get(90007);
        }
        if (this.session.isClosed()) {
            throw DbException.get(90121);
        }
    }

    String getURL() {
        this.checkClosed();
        return this.url;
    }

    String getUser() {
        this.checkClosed();
        return this.user;
    }

    private void rollbackInternal() {
        this.rollback = this.prepareCommand("ROLLBACK", this.rollback);
        this.rollback.executeUpdate(null);
    }

    public int getPowerOffCount() {
        return this.session == null || this.session.isClosed() ? 0 : this.session.getPowerOffCount();
    }

    public void setPowerOffCount(int n) {
        if (this.session != null) {
            this.session.setPowerOffCount(n);
        }
    }

    public void setExecutingStatement(Statement statement) {
        this.executingStatement = statement;
    }

    boolean scopeGeneratedKeys() {
        return this.scopeGeneratedKeys;
    }

    JdbcResultSet getGeneratedKeys(JdbcStatement jdbcStatement, int n) {
        this.getGeneratedKeys = this.prepareCommand("SELECT SCOPE_IDENTITY() WHERE SCOPE_IDENTITY() IS NOT NULL", this.getGeneratedKeys);
        ResultInterface resultInterface = this.getGeneratedKeys.executeQuery(0, false);
        return new JdbcResultSet(this, jdbcStatement, this.getGeneratedKeys, resultInterface, n, false, true, false);
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(10);
            this.debugCodeAssign("Clob", 10, n, "createClob()");
            this.checkClosedForWrite();
            return new JdbcClob(this, ValueString.EMPTY, JdbcLob.State.NEW, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(9);
            this.debugCodeAssign("Blob", 9, n, "createClob()");
            this.checkClosedForWrite();
            return new JdbcBlob(this, ValueBytes.EMPTY, JdbcLob.State.NEW, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(10);
            this.debugCodeAssign("NClob", 10, n, "createNClob()");
            this.checkClosedForWrite();
            return new JdbcClob(this, ValueString.EMPTY, JdbcLob.State.NEW, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(17);
            this.debugCodeAssign("SQLXML", 17, n, "createSQLXML()");
            this.checkClosedForWrite();
            return new JdbcSQLXML(this, (Value)ValueString.EMPTY, JdbcLob.State.NEW, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(16);
            this.debugCodeAssign("Array", 16, n, "createArrayOf()");
            this.checkClosed();
            Value value = DataType.convertToValue(this.session, objectArray, 17);
            return new JdbcArray(this, value, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw this.unsupported("Struct");
    }

    @Override
    public synchronized boolean isValid(int n) {
        try {
            this.debugCodeCall("isValid", n);
            if (this.session == null || this.session.isClosed()) {
                return false;
            }
            this.getTransactionIsolation();
            return true;
        }
        catch (Exception exception) {
            this.logAndConvert(exception);
            return false;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClientInfo(" + JdbcConnection.quote(string) + ", " + JdbcConnection.quote(string2) + ");");
            }
            this.checkClosed();
            if (Objects.equals(string2, this.getClientInfo(string))) {
                return;
            }
            if (JdbcConnection.isInternalProperty(string)) {
                throw new SQLClientInfoException("Property name '" + string + " is used internally by H2.", Collections.emptyMap());
            }
            Pattern pattern = this.getMode().supportedClientInfoPropertiesRegEx;
            if (pattern != null && pattern.matcher(string).matches()) {
                if (this.clientInfo == null) {
                    this.clientInfo = new HashMap<String, String>();
                }
            } else {
                throw new SQLClientInfoException("Client info name '" + string + "' not supported.", Collections.emptyMap());
            }
            this.clientInfo.put(string, string2);
        }
        catch (Exception exception) {
            throw JdbcConnection.convertToClientInfoException(this.logAndConvert(exception));
        }
    }

    private static boolean isInternalProperty(String string) {
        return NUM_SERVERS.equals(string) || string.startsWith(PREFIX_SERVER);
    }

    private static SQLClientInfoException convertToClientInfoException(SQLException sQLException) {
        if (sQLException instanceof SQLClientInfoException) {
            return (SQLClientInfoException)sQLException;
        }
        return new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), null, null);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClientInfo(properties);");
            }
            this.checkClosed();
            if (this.clientInfo == null) {
                this.clientInfo = new HashMap<String, String>();
            } else {
                this.clientInfo.clear();
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.setClientInfo((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Exception exception) {
            throw JdbcConnection.convertToClientInfoException(this.logAndConvert(exception));
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getClientInfo();");
            }
            this.checkClosed();
            ArrayList<String> arrayList = this.session.getClusterServers();
            Properties properties = new Properties();
            if (this.clientInfo != null) {
                for (Map.Entry<String, String> entry : this.clientInfo.entrySet()) {
                    properties.setProperty(entry.getKey(), entry.getValue());
                }
            }
            properties.setProperty(NUM_SERVERS, Integer.toString(arrayList.size()));
            for (int i = 0; i < arrayList.size(); ++i) {
                properties.setProperty(PREFIX_SERVER + i, arrayList.get(i));
            }
            return properties;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getClientInfo", string);
            }
            this.checkClosed();
            if (string == null) {
                throw DbException.getInvalidValueException("name", null);
            }
            return this.getClientInfo().getProperty(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            if (this.isWrapperFor(clazz)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", clazz);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    public Value createClob(Reader reader, long l) {
        if (reader == null) {
            return ValueNull.INSTANCE;
        }
        if (l <= 0L) {
            l = -1L;
        }
        Value value = this.session.getDataHandler().getLobStorage().createClob(reader, l);
        this.session.addTemporaryLob(value);
        return value;
    }

    public Value createBlob(InputStream inputStream, long l) {
        if (inputStream == null) {
            return ValueNull.INSTANCE;
        }
        if (l <= 0L) {
            l = -1L;
        }
        Value value = this.session.getDataHandler().getLobStorage().createBlob(inputStream, l);
        this.session.addTemporaryLob(value);
        return value;
    }

    @Override
    public void setSchema(String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("setSchema", string);
            }
            this.checkClosed();
            this.session.setCurrentSchemaName(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSchema");
            }
            this.checkClosed();
            return this.session.getCurrentSchemaName();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void abort(Executor executor) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) {
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    static void checkMap(Map<String, Class<?>> map) {
        if (map != null && map.size() > 0) {
            throw DbException.getUnsupportedException("map.size > 0");
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.user;
    }

    Object convertToDefaultObject(Value value) {
        switch (value.getValueType()) {
            case 16: {
                int n = JdbcConnection.getNextId(10);
                return new JdbcClob(this, value, JdbcLob.State.WITH_VALUE, n);
            }
            case 15: {
                int n = JdbcConnection.getNextId(9);
                return new JdbcBlob(this, value, JdbcLob.State.WITH_VALUE, n);
            }
            case 19: {
                if (!SysProperties.serializeJavaObject) break;
                return JdbcUtils.deserialize(value.getBytesNoCopy(), this.session.getDataHandler());
            }
            case 18: {
                int n = JdbcConnection.getNextId(4);
                return new JdbcResultSet(this, null, null, ((ValueResultSet)value).getResult(), n, false, true, false);
            }
            case 2: 
            case 3: {
                if (SysProperties.OLD_RESULT_SET_GET_OBJECT) break;
                return value.getInt();
            }
        }
        return value.getObject();
    }

    CompareMode getCompareMode() {
        return this.session.getDataHandler().getCompareMode();
    }

    public void setTraceLevel(int n) {
        this.trace.setLevel(n);
    }

    @Override
    public Mode getMode() {
        try {
            return this.getSettings().mode;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public Settings getSettings() throws SQLException {
        Settings settings = this.settings;
        if (settings == null) {
            String string = Mode.ModeEnum.REGULAR.name();
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            try (Object object = this.prepareStatement("SELECT NAME, VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME IN (?, ?, ?, ?)");){
                object.setString(1, "MODE");
                object.setString(2, "DATABASE_TO_UPPER");
                object.setString(3, "DATABASE_TO_LOWER");
                object.setString(4, "CASE_INSENSITIVE_IDENTIFIERS");
                ResultSet resultSet = object.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(2);
                    switch (resultSet.getString(1)) {
                        case "MODE": {
                            string = string2;
                            break;
                        }
                        case "DATABASE_TO_UPPER": {
                            bl = Boolean.valueOf(string2);
                            break;
                        }
                        case "DATABASE_TO_LOWER": {
                            bl2 = Boolean.valueOf(string2);
                            break;
                        }
                        case "CASE_INSENSITIVE_IDENTIFIERS": {
                            bl3 = Boolean.valueOf(string2);
                        }
                    }
                }
            }
            object = Mode.getInstance(string);
            if (object == null) {
                object = Mode.getRegular();
            }
            if (this.session instanceof SessionRemote && ((SessionRemote)this.session).getClientVersion() < 18) {
                bl3 = !bl;
            }
            this.settings = settings = new Settings((Mode)object, bl, bl2, bl3);
        }
        return settings;
    }

    public boolean isRegularMode() {
        this.settings = null;
        return this.getMode().getEnum() == Mode.ModeEnum.REGULAR;
    }

    @Override
    public ValueTimestampTimeZone currentTimestamp() {
        if (this.session instanceof CastDataProvider) {
            return ((CastDataProvider)((Object)this.session)).currentTimestamp();
        }
        return CurrentTimestamp.get();
    }

    public static final class Settings {
        public final Mode mode;
        public final boolean databaseToUpper;
        public final boolean databaseToLower;
        public final boolean caseInsensitiveIdentifiers;

        Settings(Mode mode, boolean bl, boolean bl2, boolean bl3) {
            this.mode = mode;
            this.databaseToUpper = bl;
            this.databaseToLower = bl2;
            this.caseInsensitiveIdentifiers = bl3;
        }
    }
}

