/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.ignite;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;

public abstract class AbstractIgniteProcessor
extends AbstractProcessor {
    public static final PropertyDescriptor IGNITE_CONFIGURATION_FILE = new PropertyDescriptor.Builder().displayName("Ignite Spring Properties Xml File").name("ignite-spring-properties-xml-file").description("Ignite spring configuration file, <path>/<ignite-configuration>.xml. If the configuration file is not provided, default Ignite configuration configuration is used which binds to 127.0.0.1:47500..47509").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are written to Ignite cache are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot be written to Ignite cache are routed to this relationship").build();
    private transient Ignite ignite;

    protected Ignite getIgnite() {
        return this.ignite;
    }

    public void closeIgnite() {
        if (this.ignite != null) {
            this.getLogger().info("Closing ignite client");
            this.ignite.close();
            this.ignite = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeIgnite(ProcessContext context) {
        if (this.getIgnite() != null) {
            this.getLogger().info("Ignite already initialized");
            return;
        }
        Class<Ignition> clazz = Ignition.class;
        synchronized (Ignition.class) {
            List grids = Ignition.allGrids();
            if (grids.size() == 1) {
                this.getLogger().info("Ignite grid already available");
                this.ignite = (Ignite)grids.get(0);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Ignition.setClientMode((boolean)true);
            String configuration = context.getProperty(IGNITE_CONFIGURATION_FILE).getValue();
            this.getLogger().info("Initializing ignite with configuration {} ", new Object[]{configuration});
            this.ignite = StringUtils.isEmpty((CharSequence)configuration) ? Ignition.start() : Ignition.start((String)configuration);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

