/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.ignite.cache;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.ignite.cache.AbstractIgniteCacheProcessor;
import org.apache.nifi.processors.ignite.cache.PutIgniteCache;

@EventDriven
@SupportsBatching
@Tags(value={"Ignite", "get", "read", "cache", "key"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Get the byte array from Ignite Cache and adds it as the content of a FlowFile.The processor uses the value of FlowFile attribute (Ignite cache entry key) as the cache key lookup. If the entry corresponding to the key is not found in the cache an error message is associated with the FlowFile Note - The Ignite Kernel periodically outputs node performance statistics to the logs. This message  can be turned off by setting the log level for logger 'org.apache.ignite' to WARN in the logback.xml configuration file.")
@WritesAttributes(value={@WritesAttribute(attribute="ignite.cache.get.failed.reason", description="The reason for getting entry from cache")})
@SeeAlso(value={PutIgniteCache.class})
public class GetIgniteCache
extends AbstractIgniteCacheProcessor {
    public static final String IGNITE_GET_FAILED_REASON_ATTRIBUTE_KEY = "ignite.cache.get.failed.reason";
    public static final String IGNITE_GET_FAILED_MISSING_KEY_MESSAGE = "The FlowFile key attribute was missing";
    public static final String IGNITE_GET_FAILED_MISSING_ENTRY_MESSAGE = "The cache byte array entry was null or zero length";
    public static final String IGNITE_GET_FAILED_MESSAGE_PREFIX = "The cache request failed because of ";
    protected static final List<PropertyDescriptor> descriptors = Arrays.asList(IGNITE_CONFIGURATION_FILE, CACHE_NAME, IGNITE_CACHE_ENTRY_KEY);

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return descriptors;
    }

    @OnScheduled
    public final void initialize(ProcessContext context) throws ProcessException {
        super.initializeIgniteCache(context);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String key = context.getProperty(IGNITE_CACHE_ENTRY_KEY).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isEmpty((CharSequence)key)) {
            flowFile = session.putAttribute(flowFile, IGNITE_GET_FAILED_REASON_ATTRIBUTE_KEY, IGNITE_GET_FAILED_MISSING_KEY_MESSAGE);
            session.transfer(flowFile, REL_FAILURE);
        } else {
            try {
                byte[] value = (byte[])this.getIgniteCache().get((Object)key);
                if (value == null || value.length == 0) {
                    flowFile = session.putAttribute(flowFile, IGNITE_GET_FAILED_REASON_ATTRIBUTE_KEY, IGNITE_GET_FAILED_MISSING_ENTRY_MESSAGE);
                    session.transfer(flowFile, REL_FAILURE);
                } else {
                    ByteArrayInputStream bais = new ByteArrayInputStream(value);
                    flowFile = session.importFrom((InputStream)bais, flowFile);
                    session.transfer(flowFile, REL_SUCCESS);
                }
            }
            catch (Exception exception) {
                flowFile = session.putAttribute(flowFile, IGNITE_GET_FAILED_REASON_ATTRIBUTE_KEY, IGNITE_GET_FAILED_MESSAGE_PREFIX + exception);
                this.getLogger().error("Failed to get value for key {} from IgniteDB due to {}", new Object[]{key, exception}, (Throwable)exception);
                session.transfer(flowFile, REL_FAILURE);
                context.yield();
            }
        }
    }
}

