/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mqtt;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.mqtt.ConsumeMQTT;
import org.apache.nifi.processors.mqtt.common.AbstractMQTTProcessor;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"publish", "MQTT", "IOT"})
@CapabilityDescription(value="Publishes a message to an MQTT topic")
@SeeAlso(value={ConsumeMQTT.class})
@SystemResourceConsideration(resource=SystemResource.MEMORY)
public class PublishMQTT
extends AbstractMQTTProcessor
implements MqttCallback {
    public static final PropertyDescriptor PROP_TOPIC = new PropertyDescriptor.Builder().name("Topic").description("The topic to publish the message to.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor PROP_QOS = new PropertyDescriptor.Builder().name("Quality of Service(QoS)").description("The Quality of Service(QoS) to send the message with. Accepts three values '0', '1' and '2'; '0' for 'at most once', '1' for 'at least once', '2' for 'exactly once'. Expression language is allowed in order to support publishing messages with different QoS but the end value of the property must be either '0', '1' or '2'. ").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(QOS_VALIDATOR).build();
    public static final PropertyDescriptor PROP_RETAIN = new PropertyDescriptor.Builder().name("Retain Message").description("Whether or not the retain flag should be set on the MQTT message.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(RETAIN_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that are sent successfully to the destination are transferred to this relationship.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that failed to send to the destination are transferred to this relationship.").build();
    private static final List<PropertyDescriptor> descriptors;
    private static final Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        this.logger = this.getLogger();
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return descriptors;
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        super.onScheduled(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnStopped
    public void onStopped(ProcessContext context) {
        PublishMQTT publishMQTT = this;
        synchronized (publishMQTT) {
            super.onStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String topic;
        FlowFile flowfile = session.get();
        if (flowfile == null) {
            return;
        }
        if (!this.isConnected()) {
            PublishMQTT publishMQTT = this;
            synchronized (publishMQTT) {
                if (!this.isConnected()) {
                    this.initializeClient(context);
                }
            }
        }
        if ((topic = context.getProperty(PROP_TOPIC).evaluateAttributeExpressions(flowfile).getValue()) == null || topic.isEmpty()) {
            this.logger.warn("Evaluation of the topic property returned null or evaluated to be empty, routing to failure");
            session.transfer(flowfile, REL_FAILURE);
            return;
        }
        final byte[] messageContent = new byte[(int)flowfile.getSize()];
        session.read(flowfile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                StreamUtils.fillBuffer((InputStream)in, (byte[])messageContent, (boolean)true);
            }
        });
        int qos = context.getProperty(PROP_QOS).evaluateAttributeExpressions(flowfile).asInteger();
        MqttMessage mqttMessage = new MqttMessage(messageContent);
        mqttMessage.setQos(qos);
        mqttMessage.setPayload(messageContent);
        mqttMessage.setRetained(context.getProperty(PROP_RETAIN).evaluateAttributeExpressions(flowfile).asBoolean().booleanValue());
        try {
            StopWatch stopWatch = new StopWatch(true);
            this.mqttClient.publish(topic, mqttMessage);
            session.getProvenanceReporter().send(flowfile, this.broker, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(flowfile, REL_SUCCESS);
        }
        catch (MqttException me) {
            this.logger.error("Failed to publish message.", (Throwable)me);
            session.transfer(flowfile, REL_FAILURE);
        }
    }

    private void initializeClient(ProcessContext context) {
        try {
            if (this.mqttClient == null) {
                this.logger.debug("Creating client");
                this.mqttClient = this.createMqttClient(this.broker, this.clientID, this.persistence);
                this.mqttClient.setCallback((MqttCallback)this);
            }
            if (!this.mqttClient.isConnected()) {
                this.logger.debug("Connecting client");
                this.mqttClient.connect(this.connOpts);
            }
        }
        catch (MqttException e) {
            this.logger.error("Connection to {} lost (or was never connected) and connection failed. Yielding processor", new Object[]{this.broker}, (Throwable)e);
            context.yield();
        }
    }

    public void connectionLost(Throwable cause) {
        this.logger.error("Connection to {} lost due to: {}", new Object[]{this.broker, cause.getMessage()}, cause);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        this.logger.error("Message arrived to a PublishMQTT processor { topic:'" + topic + "; payload:" + Arrays.toString(message.getPayload()) + "}");
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        this.logger.trace("Received 'delivery complete' message from broker for:" + token.toString());
    }

    static {
        List<PropertyDescriptor> innerDescriptorsList = PublishMQTT.getAbstractPropertyDescriptors();
        innerDescriptorsList.add(PROP_TOPIC);
        innerDescriptorsList.add(PROP_QOS);
        innerDescriptorsList.add(PROP_RETAIN);
        descriptors = Collections.unmodifiableList(innerDescriptorsList);
        HashSet<Relationship> innerRelationshipsSet = new HashSet<Relationship>();
        innerRelationshipsSet.add(REL_SUCCESS);
        innerRelationshipsSet.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(innerRelationshipsSet);
    }
}

