/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.nifi.remote.RemoteResourceManager;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.VersionedRemoteResource;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.exception.HandshakeException;
import org.apache.nifi.remote.protocol.ClientProtocol;
import org.apache.nifi.remote.protocol.ServerProtocol;

public class RemoteResourceFactory {
    public static final int RESOURCE_OK = 20;
    public static final int DIFFERENT_RESOURCE_VERSION = 21;
    public static final int ABORT = 255;

    public static VersionedRemoteResource initiateResourceNegotiation(VersionedRemoteResource resource, DataInputStream dis, DataOutputStream dos) throws IOException, HandshakeException {
        dos.writeUTF(resource.getResourceName());
        VersionNegotiator negotiator = resource.getVersionNegotiator();
        dos.writeInt(negotiator.getVersion());
        dos.flush();
        int statusCode = dis.read();
        switch (statusCode) {
            case 20: {
                return resource;
            }
            case 21: {
                int newVersion = dis.readInt();
                Integer newPreference = negotiator.getPreferredVersion(newVersion);
                if (newPreference == null) {
                    throw new HandshakeException("Could not agree on version for " + resource);
                }
                negotiator.setVersion(newPreference.intValue());
                return RemoteResourceFactory.initiateResourceNegotiation(resource, dis, dos);
            }
            case 255: {
                throw new HandshakeException("Remote destination aborted connection with message: " + dis.readUTF());
            }
        }
        return null;
    }

    public static <T extends FlowFileCodec> T receiveCodecNegotiation(DataInputStream dis, DataOutputStream dos) throws IOException, HandshakeException {
        int version;
        String codecName = dis.readUTF();
        FlowFileCodec codec = RemoteResourceManager.createCodec(codecName, version = dis.readInt());
        VersionNegotiator negotiator = codec.getVersionNegotiator();
        if (negotiator.isVersionSupported(version)) {
            dos.write(20);
            dos.flush();
            negotiator.setVersion(version);
            return (T)codec;
        }
        Integer preferred = negotiator.getPreferredVersion(version);
        if (preferred == null) {
            dos.write(255);
            dos.flush();
            throw new HandshakeException("Unable to negotiate an acceptable version of the FlowFileCodec " + codecName);
        }
        dos.write(21);
        dos.writeInt(preferred);
        dos.flush();
        return RemoteResourceFactory.receiveCodecNegotiation(dis, dos);
    }

    public static <T extends ClientProtocol> T receiveClientProtocolNegotiation(DataInputStream dis, DataOutputStream dos) throws IOException, HandshakeException {
        String protocolName = dis.readUTF();
        int version = dis.readInt();
        ClientProtocol protocol = RemoteResourceManager.createClientProtocol(protocolName);
        VersionNegotiator negotiator = protocol.getVersionNegotiator();
        if (negotiator.isVersionSupported(version)) {
            dos.write(20);
            dos.flush();
            negotiator.setVersion(version);
            return (T)protocol;
        }
        Integer preferred = negotiator.getPreferredVersion(version);
        if (preferred == null) {
            dos.write(255);
            dos.flush();
            throw new HandshakeException("Unable to negotiate an acceptable version of the ClientProtocol " + protocolName);
        }
        dos.write(21);
        dos.writeInt(preferred);
        dos.flush();
        return RemoteResourceFactory.receiveClientProtocolNegotiation(dis, dos);
    }

    public static <T extends ServerProtocol> T receiveServerProtocolNegotiation(DataInputStream dis, DataOutputStream dos) throws IOException, HandshakeException {
        String protocolName = dis.readUTF();
        int version = dis.readInt();
        ServerProtocol protocol = RemoteResourceManager.createServerProtocol(protocolName);
        VersionNegotiator negotiator = protocol.getVersionNegotiator();
        if (negotiator.isVersionSupported(version)) {
            dos.write(20);
            dos.flush();
            negotiator.setVersion(version);
            return (T)protocol;
        }
        Integer preferred = negotiator.getPreferredVersion(version);
        if (preferred == null) {
            dos.write(255);
            dos.flush();
            throw new HandshakeException("Unable to negotiate an acceptable version of the ServerProtocol " + protocolName);
        }
        dos.write(21);
        dos.writeInt(preferred);
        dos.flush();
        return RemoteResourceFactory.receiveServerProtocolNegotiation(dis, dos);
    }

    public static <T extends VersionedRemoteResource> T receiveResourceNegotiation(Class<T> cls, DataInputStream dis, DataOutputStream dos, Class<?>[] constructorArgClasses, Object[] constructorArgs) throws IOException, HandshakeException {
        VersionedRemoteResource resource;
        String resourceClassName = dis.readUTF();
        try {
            Class<?> resourceClass = Class.forName(resourceClassName);
            if (!cls.isAssignableFrom(resourceClass)) {
                throw new HandshakeException("Expected to negotiate a Versioned Resource of type " + cls.getName() + " but received class name of " + resourceClassName);
            }
            Constructor<?> ctr = resourceClass.getConstructor(constructorArgClasses);
            resource = (VersionedRemoteResource)ctr.newInstance(constructorArgs);
        }
        catch (Throwable t) {
            dos.write(255);
            String errorMsg = "Unable to instantiate Versioned Resource of type " + resourceClassName;
            dos.writeUTF(errorMsg);
            dos.flush();
            throw new HandshakeException(errorMsg);
        }
        int version = dis.readInt();
        VersionNegotiator negotiator = resource.getVersionNegotiator();
        if (negotiator.isVersionSupported(version)) {
            dos.write(20);
            dos.flush();
            negotiator.setVersion(version);
            return (T)resource;
        }
        Integer preferred = negotiator.getPreferredVersion(version);
        if (preferred == null) {
            dos.write(255);
            dos.flush();
            throw new HandshakeException("Unable to negotiate an acceptable version of the resource " + resourceClassName);
        }
        dos.write(21);
        dos.writeInt(preferred);
        dos.flush();
        return RemoteResourceFactory.receiveResourceNegotiation(cls, dis, dos, constructorArgClasses, constructorArgs);
    }
}

