/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SocketChannel;
import org.apache.nifi.remote.io.InterruptableInputStream;
import org.apache.nifi.remote.io.socket.SocketChannelInputStream;
import org.apache.nifi.remote.protocol.CommunicationsInput;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.ByteCountingInputStream;

public class SocketChannelInput
implements CommunicationsInput {
    private final SocketChannelInputStream socketIn;
    private final ByteCountingInputStream countingIn;
    private final InputStream bufferedIn;
    private final InterruptableInputStream interruptableIn;

    public SocketChannelInput(SocketChannel socketChannel) throws IOException {
        this.socketIn = new SocketChannelInputStream(socketChannel);
        this.countingIn = new ByteCountingInputStream((InputStream)this.socketIn);
        this.bufferedIn = new BufferedInputStream((InputStream)this.countingIn);
        this.interruptableIn = new InterruptableInputStream(this.bufferedIn);
    }

    public InputStream getInputStream() throws IOException {
        return this.interruptableIn;
    }

    public void setTimeout(int millis) {
        this.socketIn.setTimeout(millis);
    }

    public boolean isDataAvailable() {
        try {
            return this.interruptableIn.available() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getBytesRead() {
        return this.countingIn.getBytesRead();
    }

    public void interrupt() {
        this.interruptableIn.interrupt();
    }
}

