/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import org.apache.nifi.remote.io.InterruptableOutputStream;
import org.apache.nifi.remote.io.socket.SocketChannelOutputStream;
import org.apache.nifi.remote.protocol.CommunicationsOutput;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.stream.io.ByteCountingOutputStream;

public class SocketChannelOutput
implements CommunicationsOutput {
    private final SocketChannelOutputStream socketOutStream;
    private final ByteCountingOutputStream countingOut;
    private final OutputStream bufferedOut;
    private final InterruptableOutputStream interruptableOut;

    public SocketChannelOutput(SocketChannel socketChannel) throws IOException {
        this.socketOutStream = new SocketChannelOutputStream(socketChannel);
        this.countingOut = new ByteCountingOutputStream((OutputStream)this.socketOutStream);
        this.bufferedOut = new BufferedOutputStream((OutputStream)this.countingOut);
        this.interruptableOut = new InterruptableOutputStream(this.bufferedOut);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.interruptableOut;
    }

    public void setTimeout(int timeout) {
        this.socketOutStream.setTimeout(timeout);
    }

    public long getBytesWritten() {
        return this.countingOut.getBytesWritten();
    }

    public void interrupt() {
        this.interruptableOut.interrupt();
    }
}

