/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.configuration;

import org.apache.nifi.util.StringUtils;

public class V1TrapConfiguration {
    private final String enterpriseOid;
    private final String agentAddress;
    private final String genericTrapType;
    private final String specificTrapType;

    private V1TrapConfiguration(Builder builder) {
        this.enterpriseOid = builder.enterpriseOid;
        this.agentAddress = builder.agentAddress;
        this.genericTrapType = builder.genericTrapType;
        this.specificTrapType = builder.specificTrapType;
    }

    public String getEnterpriseOid() {
        return this.enterpriseOid;
    }

    public String getAgentAddress() {
        return this.agentAddress;
    }

    public int getGenericTrapType() {
        return Integer.parseInt(this.genericTrapType);
    }

    public Integer getSpecificTrapType() {
        if (StringUtils.isNotEmpty((String)this.specificTrapType)) {
            return Integer.parseInt(this.specificTrapType);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        String enterpriseOid;
        String agentAddress;
        String genericTrapType;
        String specificTrapType;

        public Builder enterpriseOid(String enterpriseOid) {
            this.enterpriseOid = enterpriseOid;
            return this;
        }

        public Builder agentAddress(String agentAddress) {
            this.agentAddress = agentAddress;
            return this;
        }

        public Builder genericTrapType(String genericTrapType) {
            this.genericTrapType = genericTrapType;
            return this;
        }

        public Builder specificTrapType(String specificTrapType) {
            this.specificTrapType = specificTrapType;
            return this;
        }

        public V1TrapConfiguration build() {
            block10: {
                int parsedGenericTrapType;
                if (StringUtils.isEmpty((String)this.enterpriseOid)) {
                    throw new IllegalArgumentException("Enterprise OID must be specified.");
                }
                if (StringUtils.isEmpty((String)this.agentAddress)) {
                    throw new IllegalArgumentException("Agent address must be specified.");
                }
                try {
                    parsedGenericTrapType = Integer.parseInt(this.genericTrapType);
                    if (parsedGenericTrapType < 0 || parsedGenericTrapType > 6) {
                        throw new IllegalArgumentException("Generic Trap Type must be between 0 and 6.");
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Generic Trap Type is not a number.");
                }
                if (parsedGenericTrapType == 6) {
                    try {
                        int parsedSpecificTrapType = Integer.parseInt(this.specificTrapType);
                        if (parsedSpecificTrapType < 0) {
                            throw new IllegalArgumentException("Specific Trap Type must be between 0 and 2147483647.");
                        }
                        break block10;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Generic Trap Type is [6 - Enterprise Specific] but Specific Trap Type is not provided or not a number.");
                    }
                }
                if (StringUtils.isNotEmpty((String)this.specificTrapType)) {
                    throw new IllegalArgumentException("Invalid argument: Generic Trap Type is not [6 - Enterprise Specific] but Specific Trap Type is provided.");
                }
            }
            return new V1TrapConfiguration(this);
        }
    }
}

