/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.operations;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.apache.nifi.snmp.dto.UserDetails;
import org.apache.nifi.snmp.factory.core.SNMPManagerFactory;
import org.apache.nifi.snmp.operations.SNMPTrapReceiver;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.Snmp;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;

public class SNMPTrapReceiverHandler {
    private static final Logger logger = LoggerFactory.getLogger(SNMPTrapReceiverHandler.class);
    private final SNMPConfiguration configuration;
    private final String usmUsersFilePath;
    private Snmp snmpManager;
    private boolean isStarted;

    public SNMPTrapReceiverHandler(SNMPConfiguration configuration, String usmUsersFilePath) {
        this.configuration = configuration;
        this.usmUsersFilePath = usmUsersFilePath;
        this.snmpManager = new SNMPManagerFactory().createSnmpManagerInstance(configuration);
    }

    public void createTrapReceiver(ProcessSessionFactory processSessionFactory, ComponentLog logger) {
        this.addUsmUsers();
        SNMPTrapReceiver trapReceiver = new SNMPTrapReceiver(processSessionFactory, logger);
        this.snmpManager.addCommandResponder((CommandResponder)trapReceiver);
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void close() {
        try {
            if (this.snmpManager.getUSM() != null) {
                this.snmpManager.getUSM().removeAllUsers();
                SecurityModels.getInstance().removeSecurityModel(new Integer32(this.snmpManager.getUSM().getID()));
            }
            this.snmpManager.close();
            this.isStarted = false;
        }
        catch (IOException e) {
            String errorMessage = "Could not close SNMP manager.";
            logger.error("Could not close SNMP manager.", (Throwable)e);
            throw new ProcessException("Could not close SNMP manager.");
        }
    }

    private void addUsmUsers() {
        if (this.configuration.getVersion() == 3) {
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            try (Scanner scanner = new Scanner(new File(this.usmUsersFilePath));){
                String content = scanner.useDelimiter("\\Z").next();
                ObjectMapper mapper = new ObjectMapper();
                List userDetails = (List)mapper.readValue(content, (TypeReference)new TypeReference<List<UserDetails>>(){});
                userDetails.stream().map(this::convertToUsmUser).forEach(user -> this.snmpManager.getUSM().addUser(user));
            }
            catch (FileNotFoundException e) {
                throw new ProcessException("USM user file not found, please check the file path and file permissions.", (Throwable)e);
            }
            catch (JsonProcessingException e) {
                throw new ProcessException("Could not parse USM user file, please check the processor details for examples.", (Throwable)e);
            }
        }
    }

    private UsmUser convertToUsmUser(UserDetails user) {
        return new UsmUser(new OctetString(user.getSecurityName()), SNMPUtils.getAuth(user.getAuthProtocol()), new OctetString(user.getAuthPassphrase()), SNMPUtils.getPriv(user.getPrivProtocol()), new OctetString(user.getPrivPassphrase()));
    }

    void setSnmpManager(Snmp snmpManager) {
        this.snmpManager = snmpManager;
    }
}

