/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors.properties;

import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.snmp.processors.properties.BasicProperties;

public class V1TrapProperties {
    private static final AllowableValue GENERIC_TRAP_TYPE_ENTERPRISE_SPECIFIC = new AllowableValue("6", "Enterprise Specific", "An enterpriseSpecific trap signifies that a particular enterprise-specific trap has occurred which can be defined in the Specific Trap Type field.");
    public static final PropertyDescriptor ENTERPRISE_OID = new PropertyDescriptor.Builder().name("snmp-trap-enterprise-oid").displayName("Enterprise OID").description("Enterprise is the vendor identification (OID) for the network management sub-system that generated the trap.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V1}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor AGENT_ADDRESS = new PropertyDescriptor.Builder().name("snmp-trap-agent-address").displayName("SNMP Trap Agent Address").description("The address where the SNMP Manager sends the trap.").required(true).defaultValue("0").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V1}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor GENERIC_TRAP_TYPE = new PropertyDescriptor.Builder().name("snmp-trap-generic-type").displayName("Generic Trap Type").description("Generic trap type is an integer in the range of 0 to 6. See processor usage for details.").required(false).addValidator(StandardValidators.createLongValidator((long)0L, (long)6L, (boolean)true)).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V1}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor SPECIFIC_TRAP_TYPE = new PropertyDescriptor.Builder().name("snmp-trap-specific-type").displayName("Specific Trap Type").description("Specific trap type is a number that further specifies the nature of the event that generated the trap in the case of traps of generic type 6 (enterpriseSpecific). The interpretation of this code is vendor-specific.").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V1}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();

    private V1TrapProperties() {
    }
}

