/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.processors.standard.db.impl.GenericDatabaseAdapter;
import org.apache.nifi.util.StringUtils;

public class MySQLDatabaseAdapter
extends GenericDatabaseAdapter {
    @Override
    public String getName() {
        return "MySQL";
    }

    @Override
    public String getDescription() {
        return "Generates MySQL compatible SQL";
    }

    @Override
    public String unwrapIdentifier(String identifier) {
        return identifier == null ? null : identifier.replaceAll("[\"`]", "");
    }

    @Override
    public boolean supportsUpsert() {
        return true;
    }

    @Override
    public boolean supportsInsertIgnore() {
        return true;
    }

    @Override
    public int getTimesToAddColumnObjectsForUpsert() {
        return 2;
    }

    @Override
    public String getUpsertStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        if (StringUtils.isEmpty((String)table)) {
            throw new IllegalArgumentException("Table name cannot be null or blank");
        }
        if (columnNames == null || columnNames.isEmpty()) {
            throw new IllegalArgumentException("Column names cannot be null or empty");
        }
        if (uniqueKeyColumnNames == null || uniqueKeyColumnNames.isEmpty()) {
            throw new IllegalArgumentException("Key column names cannot be null or empty");
        }
        String columns = columnNames.stream().collect(Collectors.joining(", "));
        String parameterizedInsertValues = columnNames.stream().map(__ -> "?").collect(Collectors.joining(", "));
        ArrayList<String> updateValues = new ArrayList<String>();
        for (int i = 0; i < columnNames.size(); ++i) {
            updateValues.add(columnNames.get(i) + " = ?");
        }
        String parameterizedUpdateValues = String.join((CharSequence)", ", updateValues);
        StringBuilder statementStringBuilder = new StringBuilder("INSERT INTO ").append(table).append("(").append(columns).append(")").append(" VALUES ").append("(").append(parameterizedInsertValues).append(")").append(" ON DUPLICATE KEY UPDATE ").append(parameterizedUpdateValues);
        return statementStringBuilder.toString();
    }

    @Override
    public String getInsertIgnoreStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        if (StringUtils.isEmpty((String)table)) {
            throw new IllegalArgumentException("Table name cannot be null or blank");
        }
        if (columnNames == null || columnNames.isEmpty()) {
            throw new IllegalArgumentException("Column names cannot be null or empty");
        }
        if (uniqueKeyColumnNames == null || uniqueKeyColumnNames.isEmpty()) {
            throw new IllegalArgumentException("Key column names cannot be null or empty");
        }
        String columns = columnNames.stream().collect(Collectors.joining(", "));
        String parameterizedInsertValues = columnNames.stream().map(__ -> "?").collect(Collectors.joining(", "));
        StringBuilder statementStringBuilder = new StringBuilder("INSERT IGNORE INTO ").append(table).append("(").append(columns).append(")").append(" VALUES ").append("(").append(parameterizedInsertValues).append(")");
        return statementStringBuilder.toString();
    }
}

