/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class NetworkUtils {
    public static int availablePort() {
        return NetworkUtils.getAvailableTcpPort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailableTcpPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            socket.setReuseAddress(true);
            int n = socket.getLocalPort();
            return n;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Available TCP Port not found", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailableUdpPort() {
        try (DatagramSocket socket = new DatagramSocket();){
            int n = socket.getLocalPort();
            return n;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Available UDP Port not found", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isListening(String hostname, int port) {
        try (Socket s = new Socket(hostname, port);){
            boolean bl = s.isConnected();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isListening(String hostname, int port, int timeoutMillis) {
        Boolean result = false;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            result = executor.submit(() -> {
                while (!NetworkUtils.isListening(hostname, port)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                return true;
            }).get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                executor.shutdown();
            }
            catch (Exception exception) {}
        }
        return result != null && result != false;
    }

    public static InetAddress getInterfaceAddress(String interfaceName) throws SocketException {
        InetAddress interfaceAddress = null;
        if (interfaceName != null && !interfaceName.isEmpty()) {
            NetworkInterface networkInterface = NetworkInterface.getByName(interfaceName);
            interfaceAddress = networkInterface.getInetAddresses().nextElement();
        }
        return interfaceAddress;
    }
}

