/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.security.x509.SubjectDnX509PrincipalExtractor;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;

public class DnUtils {
    private static final Pattern proxyChainPattern = Pattern.compile("<(.*?)>");

    public static String getXProxiedEntitiesChain(HttpServletRequest request) {
        String xProxiedEntitiesChain = request.getHeader("X-ProxiedEntitiesChain");
        X509Certificate cert = new X509CertificateExtractor().extractClientCertificate(request);
        if (cert != null) {
            SubjectDnX509PrincipalExtractor principalExtractor = new SubjectDnX509PrincipalExtractor();
            String extractedPrincipal = principalExtractor.extractPrincipal(cert).toString();
            String formattedPrincipal = DnUtils.formatProxyDn(extractedPrincipal);
            xProxiedEntitiesChain = StringUtils.isBlank((CharSequence)xProxiedEntitiesChain) ? formattedPrincipal : xProxiedEntitiesChain + formattedPrincipal;
        }
        return xProxiedEntitiesChain;
    }

    public static String formatProxyDn(String dn) {
        return "<" + dn + ">";
    }

    public static Deque<String> tokenizeProxyChain(String rawProxyChain) {
        ArrayDeque<String> dnList = new ArrayDeque<String>();
        Matcher rawProxyChainMatcher = proxyChainPattern.matcher(rawProxyChain);
        while (rawProxyChainMatcher.find()) {
            dnList.push(rawProxyChainMatcher.group(1));
        }
        return dnList;
    }
}

