/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.authorization;

import java.io.IOException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.user.NiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.user.NiFiUserDetails;
import org.apache.nifi.web.security.x509.SubjectDnX509PrincipalExtractor;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;
import org.apache.nifi.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.GenericFilterBean;

public class NodeAuthorizedUserFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeAuthorizedUserFilter.class);
    public static final String PROXY_USER_DETAILS = "X-ProxiedEntityUserDetails";
    private NiFiProperties properties;
    private final AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private final X509CertificateExtractor certificateExtractor = new X509CertificateExtractor();
    private final X509PrincipalExtractor principalExtractor = new SubjectDnX509PrincipalExtractor();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        WebApplicationContext ctx;
        FlowController flowController;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String hexEncodedUserDetails = httpServletRequest.getHeader(PROXY_USER_DETAILS);
        if (StringUtils.isNotBlank((CharSequence)hexEncodedUserDetails) && this.properties.isNode() && (flowController = (FlowController)(ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext())).getBean("flowController", FlowController.class)).getNodeId() != null) {
            try {
                X509Certificate certificate = this.certificateExtractor.extractClientCertificate((HttpServletRequest)request);
                if (certificate != null) {
                    Serializable userDetailsObj;
                    Object certificatePrincipal = this.principalExtractor.extractPrincipal(certificate);
                    String dn = certificatePrincipal.toString();
                    String clusterManagerDN = flowController.getClusterManagerDN();
                    if (clusterManagerDN != null && clusterManagerDN.equals(dn) && (userDetailsObj = WebUtils.deserializeHexToObject((String)hexEncodedUserDetails)) instanceof NiFiUserDetails) {
                        NiFiUserDetails userDetails = (NiFiUserDetails)((Object)userDetailsObj);
                        NiFiUser user = userDetails.getNiFiUser();
                        this.logger.info((Object)String.format("Attempting request for (%s) %s %s (source ip: %s)", user.getDn(), httpServletRequest.getMethod(), httpServletRequest.getRequestURL().toString(), request.getRemoteAddr()));
                        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                        token.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
                        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("Classpath issue detected because failed to deserialize authorized user in request header due to: " + cnfe, (Throwable)cnfe);
            }
        }
        chain.doFilter(request, response);
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

