/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateExtractor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public X509Certificate extractClientCertificate(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs != null && certs.length > 0) {
            return certs[0];
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No client certificate found in request.");
        }
        return null;
    }
}

