/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.resolver;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.security.http.SecurityCookieName;
import org.apache.nifi.web.security.http.SecurityHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.web.util.WebUtils;

public class StandardBearerTokenResolver
implements BearerTokenResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardBearerTokenResolver.class);
    private static final String BEARER_PREFIX = "Bearer ";

    public String resolve(HttpServletRequest request) {
        String bearerToken = null;
        String header = request.getHeader(SecurityHeader.AUTHORIZATION.getHeader());
        if (StringUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)BEARER_PREFIX)) {
            bearerToken = StringUtils.removeStartIgnoreCase((String)header, (String)BEARER_PREFIX);
        } else {
            Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)SecurityCookieName.AUTHORIZATION_BEARER.getName());
            if (cookie == null) {
                LOGGER.trace("Bearer Token not found in Header or Cookie");
            } else {
                bearerToken = cookie.getValue();
            }
        }
        return bearerToken;
    }
}

