/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.util.WebUtils;

public class RequestUriBuilder {
    private final String scheme;
    private final String host;
    private final int port;
    private final String contextPath;
    private String path;

    private RequestUriBuilder(String scheme, String host, int port, String contextPath) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
    }

    public static RequestUriBuilder fromHttpServletRequest(HttpServletRequest httpServletRequest, List<String> allowedContextPaths) {
        String scheme = (String)StringUtils.defaultIfEmpty((CharSequence)WebUtils.determineProxiedScheme(httpServletRequest), (CharSequence)httpServletRequest.getScheme());
        String host = WebUtils.determineProxiedHost(httpServletRequest);
        int port = WebUtils.getServerPort(httpServletRequest);
        String contextPath = WebUtils.determineContextPath(httpServletRequest);
        WebUtils.verifyContextPath(allowedContextPaths, contextPath);
        return new RequestUriBuilder(scheme, host, port, contextPath);
    }

    public RequestUriBuilder path(String path) {
        this.path = path;
        return this;
    }

    public URI build() {
        String resourcePath = StringUtils.join((Object[])new String[]{this.contextPath, this.path});
        try {
            return new URI(this.scheme, null, this.host, this.port, resourcePath, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Build URI Failed", e);
        }
    }
}

