/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.CriteriaBuilder;
import org.apache.ode.daohib.bpel.MessageExchangeDaoImpl;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HLargeData;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.ql.HibernateInstancesQueryCompiler;
import org.apache.ode.ql.eval.skel.CommandEvaluator;
import org.apache.ode.ql.tree.Builder;
import org.apache.ode.ql.tree.BuilderFactory;
import org.apache.ode.ql.tree.nodes.Node;
import org.apache.ode.ql.tree.nodes.Query;
import org.apache.ode.utils.SerializableUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunctionEx;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BpelDAOConnectionImpl
implements BpelDAOConnection {
    private static final Log __log = LogFactory.getLog(BpelDAOConnectionImpl.class);
    private Session _session;
    private SessionManager _sm;

    BpelDAOConnectionImpl(SessionManager sessionManager) {
        this._sm = sessionManager;
        this._session = this._sm.getSession();
    }

    public MessageExchangeDAO createMessageExchange(char c) {
        HMessageExchange hMessageExchange = new HMessageExchange();
        hMessageExchange.setDirection(c);
        this._session.save((Object)hMessageExchange);
        return new MessageExchangeDaoImpl(this._sm, hMessageExchange);
    }

    public MessageExchangeDAO getMessageExchange(String string) {
        HMessageExchange hMessageExchange = (HMessageExchange)this._session.get(HMessageExchange.class, (Serializable)new Long(string));
        return hMessageExchange == null ? null : new MessageExchangeDaoImpl(this._sm, hMessageExchange);
    }

    public ProcessDAO createProcess(QName qName, QName qName2, String string, long l) {
        HProcess hProcess = new HProcess();
        hProcess.setProcessId(qName.toString());
        hProcess.setTypeName(qName2.getLocalPart());
        hProcess.setTypeNamespace(qName2.getNamespaceURI());
        hProcess.setDeployDate(new Date());
        hProcess.setGuid(string);
        hProcess.setVersion(l);
        this._session.save((Object)hProcess);
        return new ProcessDaoImpl(this._sm, hProcess);
    }

    public ProcessDAO getProcess(QName qName) {
        try {
            Criteria criteria = this._session.createCriteria(HProcess.class);
            criteria.add((Criterion)Expression.eq((String)"processId", (Object)qName.toString()));
            HProcess hProcess = (HProcess)criteria.uniqueResult();
            return hProcess == null ? null : new ProcessDaoImpl(this._sm, hProcess);
        }
        catch (HibernateException hibernateException) {
            __log.error((Object)"DbError", (Throwable)hibernateException);
            throw hibernateException;
        }
    }

    public void close() {
    }

    public ProcessInstanceDAO getInstance(Long l) {
        return BpelDAOConnectionImpl._getInstance(this._sm, this._session, l);
    }

    public ScopeDAO getScope(Long l) {
        return BpelDAOConnectionImpl._getScope(this._sm, this._session, l);
    }

    public Collection<ProcessInstanceDAO> instanceQuery(InstanceFilter instanceFilter) {
        if (instanceFilter.getLimit() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProcessInstanceDAO> arrayList = new ArrayList<ProcessInstanceDAO>();
        Iterator<HProcessInstance> iterator = BpelDAOConnectionImpl._instanceQuery(this._session, false, instanceFilter);
        while (iterator.hasNext()) {
            arrayList.add(new ProcessInstanceDaoImpl(this._sm, iterator.next()));
        }
        return arrayList;
    }

    static Iterator<HProcessInstance> _instanceQuery(Session session, boolean bl, InstanceFilter instanceFilter) {
        Criteria criteria = session.createCriteria(HProcessInstance.class);
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder();
        criteriaBuilder.buildCriteria(criteria, instanceFilter);
        return criteria.list().iterator();
    }

    static ProcessInstanceDAO _getInstance(SessionManager sessionManager, Session session, Long l) {
        HProcessInstance hProcessInstance = (HProcessInstance)session.get(HProcessInstance.class, (Serializable)l);
        return hProcessInstance != null ? new ProcessInstanceDaoImpl(sessionManager, hProcessInstance) : null;
    }

    static ScopeDAO _getScope(SessionManager sessionManager, Session session, Long l) {
        HScope hScope = (HScope)session.get(HScope.class, (Serializable)l);
        return hScope != null ? new ScopeDaoImpl(sessionManager, hScope) : null;
    }

    public void insertBpelEvent(BpelEvent bpelEvent, ProcessDAO processDAO, ProcessInstanceDAO processInstanceDAO) {
        BpelDAOConnectionImpl._insertBpelEvent(this._sm.getSession(), bpelEvent, processDAO, processInstanceDAO);
    }

    static void _insertBpelEvent(Session session, BpelEvent bpelEvent, ProcessDAO processDAO, ProcessInstanceDAO processInstanceDAO) {
        HBpelEvent hBpelEvent = new HBpelEvent();
        hBpelEvent.setTstamp(new Timestamp(System.currentTimeMillis()));
        hBpelEvent.setType(BpelEvent.eventName((BpelEvent)bpelEvent));
        hBpelEvent.setDetail(bpelEvent.toString());
        if (processDAO != null) {
            hBpelEvent.setProcess((HProcess)((ProcessDaoImpl)processDAO).getHibernateObj());
        }
        if (processInstanceDAO != null) {
            hBpelEvent.setInstance((HProcessInstance)((ProcessInstanceDaoImpl)processInstanceDAO).getHibernateObj());
        }
        if (bpelEvent instanceof ScopeEvent) {
            hBpelEvent.setScopeId(((ScopeEvent)bpelEvent).getScopeId());
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(bpelEvent);
            objectOutputStream.flush();
            HLargeData hLargeData = new HLargeData(byteArrayOutputStream.toByteArray());
            hBpelEvent.setData(hLargeData);
            session.save((Object)hLargeData);
        }
        catch (Throwable throwable) {
            __log.fatal((Object)"InternalError: BpelEvent serialization failed.", throwable);
        }
        session.save((Object)hBpelEvent);
    }

    public List<Date> bpelEventTimelineQuery(InstanceFilter instanceFilter, BpelEventFilter bpelEventFilter) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder();
        Criteria criteria = this._session.createCriteria(HBpelEvent.class);
        if (instanceFilter != null) {
            criteriaBuilder.buildCriteria(criteria, bpelEventFilter);
        }
        if (instanceFilter != null) {
            criteriaBuilder.buildCriteria(criteria.createCriteria("instance"), instanceFilter);
        }
        criteria.setFetchMode("tstamp", FetchMode.EAGER);
        criteria.setProjection((Projection)Projections.property((String)"tstamp"));
        return criteria.list();
    }

    public List<BpelEvent> bpelEventQuery(InstanceFilter instanceFilter, BpelEventFilter bpelEventFilter) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder();
        Criteria criteria = this._session.createCriteria(HBpelEvent.class);
        if (bpelEventFilter != null) {
            criteriaBuilder.buildCriteria(criteria, bpelEventFilter);
        }
        if (instanceFilter != null) {
            criteriaBuilder.buildCriteria(criteria.createCriteria("instance"), instanceFilter);
        }
        List list = criteria.list();
        ArrayList<BpelEvent> arrayList = new ArrayList<BpelEvent>(list.size());
        try {
            CollectionsX.transformEx(arrayList, (Collection)list, (UnaryFunctionEx)new UnaryFunctionEx<HBpelEvent, BpelEvent>(){

                public BpelEvent apply(HBpelEvent hBpelEvent) throws Exception {
                    return (BpelEvent)SerializableUtils.toObject((byte[])hBpelEvent.getData().getBinary(), (ClassLoader)BpelEvent.class.getClassLoader());
                }
            });
        }
        catch (Exception exception) {
            __log.fatal((Object)"Internal error: unable to transform HBpelEvent", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        return arrayList;
    }

    public Collection<ProcessInstanceDAO> instanceQuery(String string) {
        Builder builder = BuilderFactory.getInstance().createBuilder();
        Node node = builder.build((Object)string);
        HibernateInstancesQueryCompiler hibernateInstancesQueryCompiler = new HibernateInstancesQueryCompiler();
        CommandEvaluator<List, Session> commandEvaluator = hibernateInstancesQueryCompiler.compile((Query)node);
        List list = (List)commandEvaluator.evaluate((Object)this._session);
        ArrayList<ProcessInstanceDAO> arrayList = new ArrayList<ProcessInstanceDAO>(list.size());
        for (HProcessInstance hProcessInstance : list) {
            arrayList.add(this.getInstance(hProcessInstance.getId()));
        }
        return arrayList;
    }
}

