/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelationProperty;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorrelationSetDaoImpl
extends HibernateDao
implements CorrelationSetDAO {
    private HCorrelationSet _correlationSet;

    public CorrelationSetDaoImpl(SessionManager sessionManager, HCorrelationSet hCorrelationSet) {
        super(sessionManager, hCorrelationSet);
        this._correlationSet = hCorrelationSet;
    }

    public Long getCorrelationSetId() {
        return this._correlationSet.getId();
    }

    public String getName() {
        return this._correlationSet.getName();
    }

    public ScopeDAO getScope() {
        return new ScopeDaoImpl(this._sm, this._correlationSet.getScope());
    }

    public void setValue(QName[] qNameArray, CorrelationKey correlationKey) {
        this._correlationSet.setValue(correlationKey.toCanonicalString());
        if (this._correlationSet.getProperties() == null || this._correlationSet.getProperties().size() == 0) {
            for (int i = 0; i < qNameArray.length; ++i) {
                HCorrelationProperty hCorrelationProperty = new HCorrelationProperty(qNameArray[i], correlationKey.getValues()[i], this._correlationSet);
                this.getSession().save((Object)hCorrelationProperty);
            }
        } else {
            for (int i = 0; i < qNameArray.length; ++i) {
                HCorrelationProperty hCorrelationProperty = this.getProperty(qNameArray[i]);
                if (hCorrelationProperty == null) {
                    hCorrelationProperty = new HCorrelationProperty(qNameArray[i], correlationKey.getValues()[i], this._correlationSet);
                } else {
                    hCorrelationProperty.setValue(correlationKey.getValues()[i]);
                }
                this.getSession().save((Object)hCorrelationProperty);
            }
        }
        this.getSession().update((Object)this._correlationSet);
    }

    public CorrelationKey getValue() {
        if (this._correlationSet.getValue() != null) {
            return new CorrelationKey(this._correlationSet.getValue());
        }
        return null;
    }

    public Map<QName, String> getProperties() {
        HashMap<QName, String> hashMap = new HashMap<QName, String>();
        for (HCorrelationProperty hCorrelationProperty : this._correlationSet.getProperties()) {
            hashMap.put(hCorrelationProperty.getQName(), hCorrelationProperty.getValue());
        }
        return hashMap;
    }

    private HCorrelationProperty getProperty(QName qName) {
        for (HCorrelationProperty hCorrelationProperty : this._correlationSet.getProperties()) {
            if (!qName.getLocalPart().equals(hCorrelationProperty.getName()) || !qName.getNamespaceURI().equals(hCorrelationProperty.getNamespace())) continue;
            return hCorrelationProperty;
        }
        return null;
    }
}

