/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactoryJDBC;
import org.apache.ode.daohib.DataSourceConnectionProvider;
import org.apache.ode.daohib.HibernateTransactionManagerLookup;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.BpelDAOConnectionImpl;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;

public class BpelDAOConnectionFactoryImpl
implements BpelDAOConnectionFactoryJDBC {
    private static final Log __log = LogFactory.getLog(BpelDAOConnectionFactoryImpl.class);
    private SessionManager _sessionManager;
    private DataSource _ds;
    private TransactionManager _tm;
    private static final String DEFAULT_HIBERNATE_DIALECT = "org.hibernate.dialect.DerbyDialect";
    private static final HashMap<String, DialectFactory.VersionInsensitiveMapper> HIBERNATE_DIALECTS = new HashMap();

    public BpelDAOConnection getConnection() {
        try {
            return new BpelDAOConnectionImpl(this._sessionManager);
        }
        catch (HibernateException hibernateException) {
            __log.error((Object)"DbError", (Throwable)hibernateException);
            throw hibernateException;
        }
    }

    public void init(Properties properties) {
        Object object;
        if (this._ds == null) {
            String string = "setDataSource() not called!";
            __log.fatal((Object)string);
            throw new IllegalStateException(string);
        }
        if (this._tm == null) {
            String string = "setTransactionManager() not called!";
            __log.fatal((Object)string);
            throw new IllegalStateException(string);
        }
        if (properties == null) {
            properties = new Properties();
        }
        Properties properties2 = new Properties();
        Object object2 = properties.keySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            properties2.put(object, properties.get(object));
        }
        if (properties2.containsKey("hibernate.connection.provider_class")) {
            __log.warn((Object)"Ignoring user-specified Hibernate property: hibernate.connection.provider_class");
        }
        if (properties2.containsKey("hibernate.transaction.manager_lookup_class")) {
            __log.warn((Object)"Ignoring user-specified Hibernate property: hibernate.transaction.manager_lookup_class");
        }
        if (properties2.containsKey("hibernate.session_factory_name")) {
            __log.warn((Object)"Ignoring user-specified Hibernate property: hibernate.session_factory_name");
        }
        properties2.put("hibernate.connection.provider_class", DataSourceConnectionProvider.class.getName());
        properties2.put("hibernate.transaction.manager_lookup_class", HibernateTransactionManagerLookup.class.getName());
        properties2.put("hibernate.transaction.factory_class", "org.hibernate.transaction.JTATransactionFactory");
        properties2.put("hibernate.current_session_context_class", "jta");
        if (properties2.get("hibernate.dialect") == null) {
            try {
                properties2.put("hibernate.dialect", this.guessDialect(this._ds));
            }
            catch (Exception exception) {
                object = "Unable to detect Hibernate dialect!";
                if (__log.isDebugEnabled()) {
                    __log.debug(object, (Throwable)exception);
                }
                __log.error(object);
            }
        }
        if (System.getProperty("ode.connection.isolation") != null) {
            object2 = System.getProperty("ode.connection.isolation", "2");
            properties2.put("hibernate.connection.isolation", object2);
        }
        this._sessionManager = object2 = new SessionManager(properties2, this._ds, this._tm);
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessDialect(DataSource dataSource) throws Exception {
        String string = null;
        Connection connection = dataSource.getConnection();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null) {
                String string2 = databaseMetaData.getDatabaseProductName();
                int n = databaseMetaData.getDatabaseMajorVersion();
                __log.info((Object)("Using database " + string2 + " major version " + n));
                DialectFactory.DatabaseDialectMapper databaseDialectMapper = (DialectFactory.DatabaseDialectMapper)HIBERNATE_DIALECTS.get(string2);
                if (databaseDialectMapper != null) {
                    string = databaseDialectMapper.getDialectClass(n);
                } else {
                    Dialect dialect = DialectFactory.determineDialect((String)string2, (int)n);
                    if (dialect != null) {
                        string = dialect.getClass().getName();
                    }
                }
            }
        }
        finally {
            connection.close();
        }
        if (string == null) {
            __log.info((Object)"Cannot determine hibernate dialect for this database: using the default one.");
            string = DEFAULT_HIBERNATE_DIALECT;
        }
        return string;
    }

    public void setDataSource(DataSource dataSource) {
        this._ds = dataSource;
    }

    public void setTransactionManager(Object object) {
        this._tm = (TransactionManager)object;
    }

    public void setUnmanagedDataSource(DataSource dataSource) {
    }

    static {
        HIBERNATE_DIALECTS.put("Apache Derby", new DialectFactory.VersionInsensitiveMapper(DEFAULT_HIBERNATE_DIALECT));
    }
}

