/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.BpelDAOConnectionImpl;
import org.apache.ode.daohib.bpel.CorrelatorDaoImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HCorrelator;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessDaoImpl
extends HibernateDao
implements ProcessDAO {
    private static final String QRY_CORRELATOR = "where this.correlatorId = ?";
    private HProcess _process;

    public ProcessDaoImpl(SessionManager sessionManager, HProcess hProcess) {
        super(sessionManager, hProcess);
        this._process = hProcess;
    }

    public QName getProcessId() {
        return QName.valueOf(this._process.getProcessId());
    }

    public ProcessInstanceDAO getInstance(Long l) {
        ProcessInstanceDAO processInstanceDAO = BpelDAOConnectionImpl._getInstance(this._sm, this.getSession(), l);
        if (processInstanceDAO == null || !processInstanceDAO.getProcess().getProcessId().equals(this.getProcessId())) {
            return null;
        }
        return processInstanceDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorrelatorDAO getCorrelator(String string) {
        Query query = this.getSession().createFilter(this._process.getCorrelators(), QRY_CORRELATOR);
        Iterator iterator = query.setString(0, string).iterate();
        if (!iterator.hasNext()) {
            String string2 = "no such correlator: corrId = " + string;
            throw new IllegalArgumentException(string2);
        }
        try {
            CorrelatorDaoImpl correlatorDaoImpl = new CorrelatorDaoImpl(this._sm, (HCorrelator)iterator.next());
            return correlatorDaoImpl;
        }
        finally {
            Hibernate.close((Iterator)iterator);
        }
    }

    public void removeRoutes(String string, ProcessInstanceDAO processInstanceDAO) {
        for (HCorrelator hCorrelator : this._process.getCorrelators()) {
            new CorrelatorDaoImpl(this._sm, hCorrelator).removeRoutes(string, processInstanceDAO);
        }
    }

    public ProcessInstanceDAO createInstance(CorrelatorDAO correlatorDAO) {
        HProcessInstance hProcessInstance = new HProcessInstance();
        hProcessInstance.setInstantiatingCorrelator((HCorrelator)((CorrelatorDaoImpl)correlatorDAO).getHibernateObj());
        hProcessInstance.setProcess(this._process);
        hProcessInstance.setCreated(new Date());
        this.getSession().save((Object)hProcessInstance);
        return new ProcessInstanceDaoImpl(this._sm, hProcessInstance);
    }

    public Collection<ProcessInstanceDAO> findInstance(CorrelationKey correlationKey) {
        Criteria criteria = this.getSession().createCriteria(HCorrelationSet.class);
        criteria.add((Criterion)Expression.eq((String)"scope.instance.process.id", (Object)this._process.getId()));
        criteria.add((Criterion)Expression.eq((String)"value", (Object)correlationKey.toCanonicalString()));
        criteria.addOrder(Order.desc((String)"scope.instance.created"));
        return criteria.list();
    }

    public void instanceCompleted(ProcessInstanceDAO processInstanceDAO) {
    }

    public void delete() {
        this.getSession().delete((Object)this._process);
    }

    public QName getType() {
        return new QName(this._process.getTypeNamespace(), this._process.getTypeName());
    }

    public long getVersion() {
        return this._process.getVersion();
    }

    public CorrelatorDAO addCorrelator(String string) {
        HCorrelator hCorrelator = new HCorrelator();
        hCorrelator.setCorrelatorId(string);
        hCorrelator.setProcess(this._process);
        hCorrelator.setCreated(new Date());
        this.getSession().save((Object)hCorrelator);
        this.getSession().saveOrUpdate((Object)this._process);
        return new CorrelatorDaoImpl(this._sm, hCorrelator);
    }

    public int getNumInstances() {
        return this._process.getInstances().size();
    }

    public String getGuid() {
        return this._process.getGuid();
    }
}

