/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.Iterator;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HLargeData;
import org.apache.ode.daohib.bpel.hobj.HVariableProperty;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.DOMUtils;
import org.hibernate.Query;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class XmlDataDaoImpl
extends HibernateDao
implements XmlDataDAO {
    private static final String QUERY_PROPERTY = "from " + HVariableProperty.class.getName() + " as p where p.xmlData.id = ? and p.name = ?";
    private HXmlData _data;
    private Node _node;

    public XmlDataDaoImpl(SessionManager sessionManager, HXmlData hXmlData) {
        super(sessionManager, hXmlData);
        this._data = hXmlData;
    }

    public boolean isNull() {
        return this._data.getData() == null;
    }

    public Node get() {
        if (this._node == null) {
            this._node = this.prepare();
        }
        return this._node;
    }

    public void remove() {
    }

    public void set(Node node) {
        this._node = node;
        this._data.setSimpleType(!(node instanceof Element));
        if (this._data.getData() != null) {
            this._sm.getSession().delete((Object)this._data.getData());
        }
        HLargeData hLargeData = new HLargeData();
        if (this._data.isSimpleType()) {
            hLargeData.setBinary(this._node.getNodeValue().getBytes());
            this._data.setData(hLargeData);
        } else {
            hLargeData.setBinary(DOMUtils.domToString((Node)this._node).getBytes());
            this._data.setData(hLargeData);
        }
        this.getSession().save((Object)hLargeData);
        this.getSession().saveOrUpdate((Object)this._data);
    }

    public String getProperty(String string) {
        HVariableProperty hVariableProperty = this._getProperty(string);
        return hVariableProperty == null ? null : hVariableProperty.getValue();
    }

    public void setProperty(String string, String string2) {
        HVariableProperty hVariableProperty = this._getProperty(string);
        if (hVariableProperty == null) {
            hVariableProperty = new HVariableProperty(this._data, string, string2);
            this.getSession().save((Object)hVariableProperty);
        } else {
            hVariableProperty.setValue(string2);
            this.getSession().update((Object)hVariableProperty);
        }
    }

    public ScopeDAO getScopeDAO() {
        return new ScopeDaoImpl(this._sm, this._data.getScope());
    }

    private HVariableProperty _getProperty(String string) {
        Query query = this.getSession().createQuery(QUERY_PROPERTY);
        query.setLong(0, this._data.getId().longValue());
        query.setString(1, string);
        Iterator iterator = query.iterate();
        return iterator.hasNext() ? (HVariableProperty)iterator.next() : null;
    }

    private Node prepare() {
        if (this._data.getData() == null) {
            return null;
        }
        String string = this._data.getData().getText();
        if (this._data.isSimpleType()) {
            Document document = DOMUtils.newDocument();
            Element element = document.createElement("text-node-wrapper");
            Text text = document.createTextNode(string);
            document.appendChild(element);
            element.appendChild(text);
            return text;
        }
        try {
            return DOMUtils.stringToDOM((String)string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getName() {
        return this._data.getName();
    }
}

