/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.daohib.bpel.hobj.HActivityRecovery;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationProperty;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HCorrelator;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorMessage;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HFaultData;
import org.apache.ode.daohib.bpel.hobj.HLargeData;
import org.apache.ode.daohib.bpel.hobj.HMessage;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HMessageExchangeProperty;
import org.apache.ode.daohib.bpel.hobj.HPartnerLink;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.hobj.HVariableProperty;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.uuid.UUID;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class SessionManager {
    private static final Log __log = LogFactory.getLog(SessionManager.class);
    public static final String PROP_GUID = "ode.hibernate.guid";
    private static final Map<String, TransactionManager> _txManagers = Collections.synchronizedMap(new HashMap());
    private static final Map<String, DataSource> _dataSources = Collections.synchronizedMap(new HashMap());
    private static final String[] CANNOT_JOIN_FOR_UPDATE_DIALECTS = new String[]{"org.hibernate.dialect.IngresDialect"};
    private final String _uuid = new UUID().toString();
    private final TransactionManager _txManager;
    private final SessionFactory _sessionFactory;
    private boolean _canJoinForUpdate = true;

    public SessionManager(Properties properties, DataSource dataSource, TransactionManager transactionManager) throws HibernateException {
        if (transactionManager == null) {
            throw new IllegalArgumentException("Null transaction manager");
        }
        this._txManager = transactionManager;
        _txManagers.put(this._uuid, transactionManager);
        _dataSources.put(this._uuid, dataSource);
        this._sessionFactory = this.getDefaultConfiguration().setProperties(properties).setProperty(PROP_GUID, this._uuid).buildSessionFactory();
        String string = properties.getProperty("hibernate.dialect");
        for (String string2 : CANNOT_JOIN_FOR_UPDATE_DIALECTS) {
            if (!string2.equals(string)) continue;
            this._canJoinForUpdate = false;
        }
    }

    TransactionManager getTransactionManager() {
        return this._txManager;
    }

    public static void registerTransactionManager(String string, TransactionManager transactionManager) {
        _txManagers.put(string, transactionManager);
    }

    public Session getSession() {
        return this._sessionFactory.getCurrentSession();
    }

    public boolean canJoinForUpdate() {
        return this._canJoinForUpdate;
    }

    public Configuration getDefaultConfiguration() throws MappingException {
        return new Configuration().addClass(HProcess.class).addClass(HProcessInstance.class).addClass(HCorrelator.class).addClass(HCorrelatorMessage.class).addClass(HCorrelationProperty.class).addClass(HCorrelatorSelector.class).addClass(HMessageExchange.class).addClass(HMessage.class).addClass(HPartnerLink.class).addClass(HScope.class).addClass(HCorrelationSet.class).addClass(HXmlData.class).addClass(HVariableProperty.class).addClass(HBpelEvent.class).addClass(HFaultData.class).addClass(HActivityRecovery.class).addClass(HLargeData.class).addClass(HMessageExchangeProperty.class);
    }

    public static TransactionManager getTransactionManager(Properties properties) {
        String string = properties.getProperty(PROP_GUID);
        return _txManagers.get(string);
    }

    public static Connection getConnection(Properties properties) throws SQLException {
        String string = properties.getProperty(PROP_GUID);
        return _dataSources.get(string).getConnection();
    }
}

